// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_FILTER_DICTIONARY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_FILTER_DICTIONARY_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CanvasFilterDictionary : public bindings::DictionaryBase {
  
  public:
static CanvasFilterDictionary* Create() {
  return MakeGarbageCollected<CanvasFilterDictionary>();
}
static CanvasFilterDictionary* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanvasFilterDictionary>(isolate);
}
static CanvasFilterDictionary* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanvasFilterDictionary();
explicit  CanvasFilterDictionary(v8::Isolate* isolate);

bool hasBlur() const {
  return has_blur_;
}
const ScriptObject& blur() const {
  DCHECK(hasBlur());
return member_blur_;
}
ScriptObject getBlurOr(const ScriptObject& fallback_value) const {
  if (!hasBlur()) {
  return fallback_value;
}
return member_blur_;
}
void setBlur(const ScriptObject& value) {
  member_blur_ = value;
has_blur_ = true;
}

bool hasColorMatrix() const {
  return has_color_matrix_;
}
const ScriptObject& colorMatrix() const {
  DCHECK(hasColorMatrix());
return member_color_matrix_;
}
ScriptObject getColorMatrixOr(const ScriptObject& fallback_value) const {
  if (!hasColorMatrix()) {
  return fallback_value;
}
return member_color_matrix_;
}
void setColorMatrix(const ScriptObject& value) {
  member_color_matrix_ = value;
has_color_matrix_ = true;
}

bool hasComponentTransfer() const {
  return has_component_transfer_;
}
const ScriptObject& componentTransfer() const {
  DCHECK(hasComponentTransfer());
return member_component_transfer_;
}
ScriptObject getComponentTransferOr(const ScriptObject& fallback_value) const {
  if (!hasComponentTransfer()) {
  return fallback_value;
}
return member_component_transfer_;
}
void setComponentTransfer(const ScriptObject& value) {
  member_component_transfer_ = value;
has_component_transfer_ = true;
}

bool hasConvolveMatrix() const {
  return has_convolve_matrix_;
}
const ScriptObject& convolveMatrix() const {
  DCHECK(hasConvolveMatrix());
return member_convolve_matrix_;
}
ScriptObject getConvolveMatrixOr(const ScriptObject& fallback_value) const {
  if (!hasConvolveMatrix()) {
  return fallback_value;
}
return member_convolve_matrix_;
}
void setConvolveMatrix(const ScriptObject& value) {
  member_convolve_matrix_ = value;
has_convolve_matrix_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_blur_ = false;
bool has_color_matrix_ = false;
bool has_component_transfer_ = false;
bool has_convolve_matrix_ = false;

ScriptObject member_blur_;
ScriptObject member_color_matrix_;
ScriptObject member_component_transfer_;
ScriptObject member_convolve_matrix_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_FILTER_DICTIONARY_H_
