// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_2D_GPU_TRANSFER_OPTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_2D_GPU_TRANSFER_OPTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class GPUDevice;

class MODULES_EXPORT Canvas2dGPUTransferOption : public bindings::InputDictionaryBase {
  
  public:
static Canvas2dGPUTransferOption* Create() {
  return MakeGarbageCollected<Canvas2dGPUTransferOption>();
}
static Canvas2dGPUTransferOption* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<Canvas2dGPUTransferOption>(isolate);
}
static Canvas2dGPUTransferOption* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  Canvas2dGPUTransferOption();
explicit  Canvas2dGPUTransferOption(v8::Isolate* isolate);

bool hasDevice() const {
  return has_device_;
}
GPUDevice* device() const {
  DCHECK(hasDevice());
return member_device_.Get();
}
GPUDevice* getDeviceOr(GPUDevice* fallback_value) const {
  if (!hasDevice()) {
  return fallback_value;
}
return member_device_.Get();
}
void setDevice(GPUDevice* value) {
  member_device_ = value;
has_device_ = true;
DCHECK(member_device_);
}

bool hasLabel() const {
  return has_label_;
}
const String& label() const {
  DCHECK(hasLabel());
return member_label_;
}
String getLabelOr(const String& fallback_value) const;
String getLabelOr(String&& fallback_value) const;
void setLabel(const String& value);
void setLabel(String&& value);

bool hasRequireZeroCopy() const {
  return true;
}
bool requireZeroCopy() const {
  return member_require_zero_copy_;
}
void setRequireZeroCopy(bool value) {
  member_require_zero_copy_ = value;
}

bool hasUsage() const {
  return true;
}
uint32_t usage() const {
  return member_usage_;
}
void setUsage(uint32_t value) {
  member_usage_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_device_ = false;
bool has_label_ = false;

Member<GPUDevice> member_device_;
String member_label_;
bool member_require_zero_copy_{false};
uint32_t member_usage_{0x14};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_2D_GPU_TRANSFER_OPTION_H_
