// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAN_MAKE_PAYMENT_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAN_MAKE_PAYMENT_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class PaymentDetailsModifier;
class PaymentMethodData;

class MODULES_EXPORT CanMakePaymentEventInit : public ExtendableEventInit {
  
  public:
static CanMakePaymentEventInit* Create() {
  return MakeGarbageCollected<CanMakePaymentEventInit>();
}
static CanMakePaymentEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanMakePaymentEventInit>(isolate);
}
static CanMakePaymentEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanMakePaymentEventInit();
explicit  CanMakePaymentEventInit(v8::Isolate* isolate);

bool hasMethodData() const {
  return has_method_data_;
}
const HeapVector<Member<PaymentMethodData>>& methodData() const {
  DCHECK(hasMethodData());
return member_method_data_;
}
HeapVector<Member<PaymentMethodData>> getMethodDataOr(const HeapVector<Member<PaymentMethodData>>& fallback_value) const;
HeapVector<Member<PaymentMethodData>> getMethodDataOr(HeapVector<Member<PaymentMethodData>>&& fallback_value) const;
void setMethodData(const HeapVector<Member<PaymentMethodData>>& value);
void setMethodData(HeapVector<Member<PaymentMethodData>>&& value);

bool hasModifiers() const {
  return has_modifiers_;
}
const HeapVector<Member<PaymentDetailsModifier>>& modifiers() const {
  DCHECK(hasModifiers());
return member_modifiers_;
}
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const;
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const;
void setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value);
void setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value);

bool hasPaymentRequestOrigin() const {
  return has_payment_request_origin_;
}
const String& paymentRequestOrigin() const {
  DCHECK(hasPaymentRequestOrigin());
return member_payment_request_origin_;
}
String getPaymentRequestOriginOr(const String& fallback_value) const;
String getPaymentRequestOriginOr(String&& fallback_value) const;
void setPaymentRequestOrigin(const String& value);
void setPaymentRequestOrigin(String&& value);

bool hasTopOrigin() const {
  return has_top_origin_;
}
const String& topOrigin() const {
  DCHECK(hasTopOrigin());
return member_top_origin_;
}
String getTopOriginOr(const String& fallback_value) const;
String getTopOriginOr(String&& fallback_value) const;
void setTopOrigin(const String& value);
void setTopOrigin(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_method_data_ = false;
bool has_modifiers_ = false;
bool has_payment_request_origin_ = false;
bool has_top_origin_ = false;

HeapVector<Member<PaymentMethodData>> member_method_data_;
HeapVector<Member<PaymentDetailsModifier>> member_modifiers_;
String member_payment_request_origin_;
String member_top_origin_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CAN_MAKE_PAYMENT_EVENT_INIT_H_
