// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_LE_SCAN_FILTER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_LE_SCAN_FILTER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class BluetoothManufacturerDataFilterInit;
class ExceptionState;
class V8UnionStringOrUnsignedLong;

class MODULES_EXPORT BluetoothLEScanFilterInit : public bindings::DictionaryBase {
  
  public:
static BluetoothLEScanFilterInit* Create() {
  return MakeGarbageCollected<BluetoothLEScanFilterInit>();
}
static BluetoothLEScanFilterInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BluetoothLEScanFilterInit>(isolate);
}
static BluetoothLEScanFilterInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BluetoothLEScanFilterInit();
explicit  BluetoothLEScanFilterInit(v8::Isolate* isolate);

bool hasManufacturerData() const {
  return has_manufacturer_data_;
}
const HeapVector<Member<BluetoothManufacturerDataFilterInit>>& manufacturerData() const {
  DCHECK(hasManufacturerData());
return member_manufacturer_data_;
}
HeapVector<Member<BluetoothManufacturerDataFilterInit>> getManufacturerDataOr(const HeapVector<Member<BluetoothManufacturerDataFilterInit>>& fallback_value) const;
HeapVector<Member<BluetoothManufacturerDataFilterInit>> getManufacturerDataOr(HeapVector<Member<BluetoothManufacturerDataFilterInit>>&& fallback_value) const;
void setManufacturerData(const HeapVector<Member<BluetoothManufacturerDataFilterInit>>& value);
void setManufacturerData(HeapVector<Member<BluetoothManufacturerDataFilterInit>>&& value);

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasNamePrefix() const {
  return has_name_prefix_;
}
const String& namePrefix() const {
  DCHECK(hasNamePrefix());
return member_name_prefix_;
}
String getNamePrefixOr(const String& fallback_value) const;
String getNamePrefixOr(String&& fallback_value) const;
void setNamePrefix(const String& value);
void setNamePrefix(String&& value);

bool hasServices() const {
  return has_services_;
}
const HeapVector<Member<V8UnionStringOrUnsignedLong>>& services() const {
  DCHECK(hasServices());
return member_services_;
}
HeapVector<Member<V8UnionStringOrUnsignedLong>> getServicesOr(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& fallback_value) const;
HeapVector<Member<V8UnionStringOrUnsignedLong>> getServicesOr(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& fallback_value) const;
void setServices(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value);
void setServices(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_manufacturer_data_ = false;
bool has_name_ = false;
bool has_name_prefix_ = false;
bool has_services_ = false;

HeapVector<Member<BluetoothManufacturerDataFilterInit>> member_manufacturer_data_;
String member_name_;
String member_name_prefix_;
HeapVector<Member<V8UnionStringOrUnsignedLong>> member_services_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_LE_SCAN_FILTER_INIT_H_
