// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_bluetooth_advertising_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_unsignedlong.h"
#include "third_party/blink/renderer/modules/bluetooth/bluetooth_device.h"
#include "third_party/blink/renderer/modules/bluetooth/bluetooth_manufacturer_data_map.h"
#include "third_party/blink/renderer/modules/bluetooth/bluetooth_service_data_map.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"appearance",
"device",
"manufacturerData",
"name",
"rssi",
"serviceData",
"txPower",
"uuids",
};


}  // namespace 

BluetoothAdvertisingEventInit* BluetoothAdvertisingEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  BluetoothAdvertisingEventInit* dictionary = MakeGarbageCollected<BluetoothAdvertisingEventInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "BluetoothAdvertisingEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 BluetoothAdvertisingEventInit::BluetoothAdvertisingEventInit() {
  
}

 BluetoothAdvertisingEventInit::BluetoothAdvertisingEventInit(v8::Isolate* isolate) : EventInit(isolate) {
  
}






















String BluetoothAdvertisingEventInit::getNameOr(const String& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

String BluetoothAdvertisingEventInit::getNameOr(String&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void BluetoothAdvertisingEventInit::setName(const String& value) {
  member_name_ = value;
has_name_ = true;
}

void BluetoothAdvertisingEventInit::setName(String&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}

























HeapVector<Member<V8UnionStringOrUnsignedLong>> BluetoothAdvertisingEventInit::getUuidsOr(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& fallback_value) const {
  if (!hasUuids()) {
  return fallback_value;
}
return member_uuids_;
}

HeapVector<Member<V8UnionStringOrUnsignedLong>> BluetoothAdvertisingEventInit::getUuidsOr(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& fallback_value) const {
  if (!hasUuids()) {
  return std::move(fallback_value);
}
return member_uuids_;
}

void BluetoothAdvertisingEventInit::setUuids(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value) {
  member_uuids_ = value;
has_uuids_ = true;
}

void BluetoothAdvertisingEventInit::setUuids(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value) {
  member_uuids_ = std::move(value);
has_uuids_ = true;
}



void BluetoothAdvertisingEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_device_);
visitor->Trace(member_manufacturer_data_);
visitor->Trace(member_service_data_);
visitor->Trace(member_uuids_);
EventInit::Trace(visitor);
}

void BluetoothAdvertisingEventInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  EventInit::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void BluetoothAdvertisingEventInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  EventInit::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAppearance()) {
  values[0] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_appearance_);
DCHECK(!values[0].IsEmpty());
}
if (hasDevice()) {
  values[1] = ToV8Traits<BluetoothDevice>::ToV8(script_state, member_device_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasManufacturerData()) {
  values[2] = ToV8Traits<BluetoothManufacturerDataMap>::ToV8(script_state, member_manufacturer_data_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasName()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_name_);
DCHECK(!values[3].IsEmpty());
}
if (hasRssi()) {
  values[4] = ToV8Traits<IDLByte>::ToV8(script_state, member_rssi_);
DCHECK(!values[4].IsEmpty());
}
if (hasServiceData()) {
  values[5] = ToV8Traits<BluetoothServiceDataMap>::ToV8(script_state, member_service_data_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasTxPower()) {
  values[6] = ToV8Traits<IDLByte>::ToV8(script_state, member_tx_power_);
DCHECK(!values[6].IsEmpty());
}
if (hasUuids()) {
  values[7] = ToV8Traits<IDLSequence<V8UnionStringOrUnsignedLong>>::ToV8(script_state, member_uuids_);
DCHECK(!values[7].IsEmpty());
}
}

const void* BluetoothAdvertisingEventInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> BluetoothAdvertisingEventInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void BluetoothAdvertisingEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "BluetoothAdvertisingEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("appearance");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_appearance_, member_appearance_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("device");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<BluetoothDevice, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_device_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("manufacturerData");
if (!bindings::GetDictionaryMemberFromV8Object<BluetoothManufacturerDataMap, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_manufacturer_data_, member_manufacturer_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rssi");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_rssi_, member_rssi_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("serviceData");
if (!bindings::GetDictionaryMemberFromV8Object<BluetoothServiceDataMap, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_service_data_, member_service_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("txPower");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByte, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_tx_power_, member_tx_power_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("uuids");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionStringOrUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_uuids_, member_uuids_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> BluetoothAdvertisingEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
