// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PRF_VALUES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PRF_VALUES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT AuthenticationExtensionsPRFValues : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsPRFValues* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsPRFValues>();
}
static AuthenticationExtensionsPRFValues* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsPRFValues>(isolate);
}
static AuthenticationExtensionsPRFValues* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsPRFValues();
explicit  AuthenticationExtensionsPRFValues(v8::Isolate* isolate);

bool hasFirst() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* first() const {
  return member_first_.Get();
}
void setFirst(V8UnionArrayBufferOrArrayBufferView* value) {
  member_first_ = value;
DCHECK(member_first_);
}

bool hasSecond() const {
  return has_second_;
}
V8UnionArrayBufferOrArrayBufferView* second() const {
  DCHECK(hasSecond());
return member_second_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getSecondOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasSecond()) {
  return fallback_value;
}
return member_second_.Get();
}
void setSecond(V8UnionArrayBufferOrArrayBufferView* value) {
  member_second_ = value;
has_second_ = true;
DCHECK(member_second_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_second_ = false;

Member<V8UnionArrayBufferOrArrayBufferView> member_first_;
Member<V8UnionArrayBufferOrArrayBufferView> member_second_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_PRF_VALUES_H_
