// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_payment_browser_bound_signature.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"signature",
};


}  // namespace 

AuthenticationExtensionsPaymentBrowserBoundSignature* AuthenticationExtensionsPaymentBrowserBoundSignature::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsPaymentBrowserBoundSignature* dictionary = MakeGarbageCollected<AuthenticationExtensionsPaymentBrowserBoundSignature>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsPaymentBrowserBoundSignature";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsPaymentBrowserBoundSignature::AuthenticationExtensionsPaymentBrowserBoundSignature() {
  
}

 AuthenticationExtensionsPaymentBrowserBoundSignature::AuthenticationExtensionsPaymentBrowserBoundSignature(v8::Isolate* isolate) {
  
}









void AuthenticationExtensionsPaymentBrowserBoundSignature::Trace(Visitor* visitor) const {
  visitor->Trace(member_signature_);
bindings::DictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsPaymentBrowserBoundSignature::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuthenticationExtensionsPaymentBrowserBoundSignature::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasSignature()) {
  values[0] = ToV8Traits<DOMArrayBuffer>::ToV8(script_state, member_signature_.Get());
DCHECK(!values[0].IsEmpty());
}
}

const void* AuthenticationExtensionsPaymentBrowserBoundSignature::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuthenticationExtensionsPaymentBrowserBoundSignature::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuthenticationExtensionsPaymentBrowserBoundSignature::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsPaymentBrowserBoundSignature";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("signature");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<DOMArrayBuffer, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_signature_, member_signature_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsPaymentBrowserBoundSignature::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
