// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_address_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"addressLine",
"city",
"country",
"dependentLocality",
"organization",
"phone",
"postalCode",
"recipient",
"region",
"sortingCode",
};


}  // namespace 

AddressInit* AddressInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AddressInit* dictionary = MakeGarbageCollected<AddressInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AddressInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AddressInit::AddressInit() {
  
}

 AddressInit::AddressInit(v8::Isolate* isolate) {
  
}



Vector<String> AddressInit::getAddressLineOr(const Vector<String>& fallback_value) const {
  if (!hasAddressLine()) {
  return fallback_value;
}
return member_address_line_;
}

Vector<String> AddressInit::getAddressLineOr(Vector<String>&& fallback_value) const {
  if (!hasAddressLine()) {
  return std::move(fallback_value);
}
return member_address_line_;
}

void AddressInit::setAddressLine(const Vector<String>& value) {
  member_address_line_ = value;
has_address_line_ = true;
}

void AddressInit::setAddressLine(Vector<String>&& value) {
  member_address_line_ = std::move(value);
has_address_line_ = true;
}




String AddressInit::getCityOr(const String& fallback_value) const {
  if (!hasCity()) {
  return fallback_value;
}
return member_city_;
}

String AddressInit::getCityOr(String&& fallback_value) const {
  if (!hasCity()) {
  return std::move(fallback_value);
}
return member_city_;
}

void AddressInit::setCity(const String& value) {
  member_city_ = value;
has_city_ = true;
}

void AddressInit::setCity(String&& value) {
  member_city_ = std::move(value);
has_city_ = true;
}




String AddressInit::getCountryOr(const String& fallback_value) const {
  if (!hasCountry()) {
  return fallback_value;
}
return member_country_;
}

String AddressInit::getCountryOr(String&& fallback_value) const {
  if (!hasCountry()) {
  return std::move(fallback_value);
}
return member_country_;
}

void AddressInit::setCountry(const String& value) {
  member_country_ = value;
has_country_ = true;
}

void AddressInit::setCountry(String&& value) {
  member_country_ = std::move(value);
has_country_ = true;
}




String AddressInit::getDependentLocalityOr(const String& fallback_value) const {
  if (!hasDependentLocality()) {
  return fallback_value;
}
return member_dependent_locality_;
}

String AddressInit::getDependentLocalityOr(String&& fallback_value) const {
  if (!hasDependentLocality()) {
  return std::move(fallback_value);
}
return member_dependent_locality_;
}

void AddressInit::setDependentLocality(const String& value) {
  member_dependent_locality_ = value;
has_dependent_locality_ = true;
}

void AddressInit::setDependentLocality(String&& value) {
  member_dependent_locality_ = std::move(value);
has_dependent_locality_ = true;
}




String AddressInit::getOrganizationOr(const String& fallback_value) const {
  if (!hasOrganization()) {
  return fallback_value;
}
return member_organization_;
}

String AddressInit::getOrganizationOr(String&& fallback_value) const {
  if (!hasOrganization()) {
  return std::move(fallback_value);
}
return member_organization_;
}

void AddressInit::setOrganization(const String& value) {
  member_organization_ = value;
has_organization_ = true;
}

void AddressInit::setOrganization(String&& value) {
  member_organization_ = std::move(value);
has_organization_ = true;
}




String AddressInit::getPhoneOr(const String& fallback_value) const {
  if (!hasPhone()) {
  return fallback_value;
}
return member_phone_;
}

String AddressInit::getPhoneOr(String&& fallback_value) const {
  if (!hasPhone()) {
  return std::move(fallback_value);
}
return member_phone_;
}

void AddressInit::setPhone(const String& value) {
  member_phone_ = value;
has_phone_ = true;
}

void AddressInit::setPhone(String&& value) {
  member_phone_ = std::move(value);
has_phone_ = true;
}




String AddressInit::getPostalCodeOr(const String& fallback_value) const {
  if (!hasPostalCode()) {
  return fallback_value;
}
return member_postal_code_;
}

String AddressInit::getPostalCodeOr(String&& fallback_value) const {
  if (!hasPostalCode()) {
  return std::move(fallback_value);
}
return member_postal_code_;
}

void AddressInit::setPostalCode(const String& value) {
  member_postal_code_ = value;
has_postal_code_ = true;
}

void AddressInit::setPostalCode(String&& value) {
  member_postal_code_ = std::move(value);
has_postal_code_ = true;
}




String AddressInit::getRecipientOr(const String& fallback_value) const {
  if (!hasRecipient()) {
  return fallback_value;
}
return member_recipient_;
}

String AddressInit::getRecipientOr(String&& fallback_value) const {
  if (!hasRecipient()) {
  return std::move(fallback_value);
}
return member_recipient_;
}

void AddressInit::setRecipient(const String& value) {
  member_recipient_ = value;
has_recipient_ = true;
}

void AddressInit::setRecipient(String&& value) {
  member_recipient_ = std::move(value);
has_recipient_ = true;
}




String AddressInit::getRegionOr(const String& fallback_value) const {
  if (!hasRegion()) {
  return fallback_value;
}
return member_region_;
}

String AddressInit::getRegionOr(String&& fallback_value) const {
  if (!hasRegion()) {
  return std::move(fallback_value);
}
return member_region_;
}

void AddressInit::setRegion(const String& value) {
  member_region_ = value;
has_region_ = true;
}

void AddressInit::setRegion(String&& value) {
  member_region_ = std::move(value);
has_region_ = true;
}




String AddressInit::getSortingCodeOr(const String& fallback_value) const {
  if (!hasSortingCode()) {
  return fallback_value;
}
return member_sorting_code_;
}

String AddressInit::getSortingCodeOr(String&& fallback_value) const {
  if (!hasSortingCode()) {
  return std::move(fallback_value);
}
return member_sorting_code_;
}

void AddressInit::setSortingCode(const String& value) {
  member_sorting_code_ = value;
has_sorting_code_ = true;
}

void AddressInit::setSortingCode(String&& value) {
  member_sorting_code_ = std::move(value);
has_sorting_code_ = true;
}



void AddressInit::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void AddressInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AddressInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAddressLine()) {
  values[0] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_address_line_);
DCHECK(!values[0].IsEmpty());
}
if (hasCity()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_city_);
DCHECK(!values[1].IsEmpty());
}
if (hasCountry()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_country_);
DCHECK(!values[2].IsEmpty());
}
if (hasDependentLocality()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_dependent_locality_);
DCHECK(!values[3].IsEmpty());
}
if (hasOrganization()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_organization_);
DCHECK(!values[4].IsEmpty());
}
if (hasPhone()) {
  values[5] = ToV8Traits<IDLString>::ToV8(script_state, member_phone_);
DCHECK(!values[5].IsEmpty());
}
if (hasPostalCode()) {
  values[6] = ToV8Traits<IDLString>::ToV8(script_state, member_postal_code_);
DCHECK(!values[6].IsEmpty());
}
if (hasRecipient()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_recipient_);
DCHECK(!values[7].IsEmpty());
}
if (hasRegion()) {
  values[8] = ToV8Traits<IDLString>::ToV8(script_state, member_region_);
DCHECK(!values[8].IsEmpty());
}
if (hasSortingCode()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_sorting_code_);
DCHECK(!values[9].IsEmpty());
}
}

const void* AddressInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AddressInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AddressInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AddressInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("addressLine");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_address_line_, member_address_line_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("city");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_city_, member_city_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("country");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_country_, member_country_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dependentLocality");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_dependent_locality_, member_dependent_locality_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("organization");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_organization_, member_organization_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("phone");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_phone_, member_phone_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("postalCode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_postal_code_, member_postal_code_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("recipient");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_recipient_, member_recipient_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("region");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_region_, member_region_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sortingCode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_sorting_code_, member_sorting_code_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AddressInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
