// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_TARGETING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_TARGETING_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class GeolocationCoordinates;

class MODULES_EXPORT AdTargeting : public bindings::InputDictionaryBase {
  
  public:
static AdTargeting* Create() {
  return MakeGarbageCollected<AdTargeting>();
}
static AdTargeting* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdTargeting>(isolate);
}
static AdTargeting* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdTargeting();
explicit  AdTargeting(v8::Isolate* isolate);

bool hasGeolocation() const {
  return has_geolocation_;
}
GeolocationCoordinates* geolocation() const {
  DCHECK(hasGeolocation());
return member_geolocation_.Get();
}
GeolocationCoordinates* getGeolocationOr(GeolocationCoordinates* fallback_value) const {
  if (!hasGeolocation()) {
  return fallback_value;
}
return member_geolocation_.Get();
}
void setGeolocation(GeolocationCoordinates* value) {
  member_geolocation_ = value;
has_geolocation_ = true;
DCHECK(member_geolocation_);
}

bool hasInterests() const {
  return has_interests_;
}
const Vector<String>& interests() const {
  DCHECK(hasInterests());
return member_interests_;
}
Vector<String> getInterestsOr(const Vector<String>& fallback_value) const;
Vector<String> getInterestsOr(Vector<String>&& fallback_value) const;
void setInterests(const Vector<String>& value);
void setInterests(Vector<String>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_geolocation_ = false;
bool has_interests_ = false;

Member<GeolocationCoordinates> member_geolocation_;
Vector<String> member_interests_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_TARGETING_H_
