// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_BUYER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_BUYER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AdAuctionDataBuyerConfig : public bindings::InputDictionaryBase {
  
  public:
static AdAuctionDataBuyerConfig* Create() {
  return MakeGarbageCollected<AdAuctionDataBuyerConfig>();
}
static AdAuctionDataBuyerConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdAuctionDataBuyerConfig>(isolate);
}
static AdAuctionDataBuyerConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdAuctionDataBuyerConfig();
explicit  AdAuctionDataBuyerConfig(v8::Isolate* isolate);

bool hasTargetSize() const {
  return has_target_size_;
}
uint32_t targetSize() const {
  DCHECK(hasTargetSize());
return member_target_size_;
}
uint32_t getTargetSizeOr(uint32_t fallback_value) const {
  if (!hasTargetSize()) {
  return fallback_value;
}
return member_target_size_;
}
void setTargetSize(uint32_t value) {
  member_target_size_ = value;
has_target_size_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_target_size_ = false;

uint32_t member_target_size_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_BUYER_CONFIG_H_
