// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AdAuctionPerSellerData;
class ExceptionState;

class MODULES_EXPORT AdAuctionData : public bindings::DictionaryBase {
  
  public:
static AdAuctionData* Create() {
  return MakeGarbageCollected<AdAuctionData>();
}
static AdAuctionData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdAuctionData>(isolate);
}
static AdAuctionData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdAuctionData();
explicit  AdAuctionData(v8::Isolate* isolate);

bool hasRequest() const {
  return has_request_;
}
NotShared<DOMUint8Array> request() const {
  DCHECK(hasRequest());
return member_request_;
}
NotShared<DOMUint8Array> getRequestOr(NotShared<DOMUint8Array> fallback_value) const {
  if (!hasRequest()) {
  return fallback_value;
}
return member_request_;
}
void setRequest(NotShared<DOMUint8Array> value) {
  member_request_ = value;
has_request_ = true;
DCHECK(member_request_);
}

bool hasRequestId() const {
  return true;
}
const String& requestId() const {
  return member_request_id_;
}
void setRequestId(const String& value);
void setRequestId(String&& value);

bool hasRequests() const {
  return has_requests_;
}
const HeapVector<Member<AdAuctionPerSellerData>>& requests() const {
  DCHECK(hasRequests());
return member_requests_;
}
HeapVector<Member<AdAuctionPerSellerData>> getRequestsOr(const HeapVector<Member<AdAuctionPerSellerData>>& fallback_value) const;
HeapVector<Member<AdAuctionPerSellerData>> getRequestsOr(HeapVector<Member<AdAuctionPerSellerData>>&& fallback_value) const;
void setRequests(const HeapVector<Member<AdAuctionPerSellerData>>& value);
void setRequests(HeapVector<Member<AdAuctionPerSellerData>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_request_ = false;
bool has_requests_ = false;

NotShared<DOMUint8Array> member_request_;
String member_request_id_;
HeapVector<Member<AdAuctionPerSellerData>> member_requests_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_H_
