// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VIEW_TRANSITION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VIEW_TRANSITION_OPTIONS_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8ViewTransitionCallback;

class CORE_EXPORT ViewTransitionOptions : public bindings::InputDictionaryBase {
  
  public:
static ViewTransitionOptions* Create() {
  return MakeGarbageCollected<ViewTransitionOptions>();
}
static ViewTransitionOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ViewTransitionOptions>(isolate);
}
static ViewTransitionOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ViewTransitionOptions();
explicit  ViewTransitionOptions(v8::Isolate* isolate);

bool hasTypes() const {
  return true;
}
const std::optional<Vector<String>>& types() const {
  return member_types_;
}
void setTypes(const std::optional<Vector<String>>& value);
void setTypes(std::optional<Vector<String>>&& value);
void setTypes(const Vector<String>& value);
void setTypes(Vector<String>&& value);

bool hasUpdate() const {
  return true;
}
V8ViewTransitionCallback* update() const {
  return member_update_.Get();
}
void setUpdate(V8ViewTransitionCallback* value) {
  member_update_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



std::optional<Vector<String>> member_types_;
Member<V8ViewTransitionCallback> member_update_{nullptr};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_VIEW_TRANSITION_OPTIONS_H_
