// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"baseURL",
"hash",
"hostname",
"password",
"pathname",
"port",
"protocol",
"search",
"username",
};


}  // namespace 

URLPatternInit* URLPatternInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  URLPatternInit* dictionary = MakeGarbageCollected<URLPatternInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "URLPatternInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 URLPatternInit::URLPatternInit() {
  
}

 URLPatternInit::URLPatternInit(v8::Isolate* isolate) {
  
}



String URLPatternInit::getBaseURLOr(const String& fallback_value) const {
  if (!hasBaseURL()) {
  return fallback_value;
}
return member_base_url_;
}

String URLPatternInit::getBaseURLOr(String&& fallback_value) const {
  if (!hasBaseURL()) {
  return std::move(fallback_value);
}
return member_base_url_;
}

void URLPatternInit::setBaseURL(const String& value) {
  member_base_url_ = value;
has_base_url_ = true;
}

void URLPatternInit::setBaseURL(String&& value) {
  member_base_url_ = std::move(value);
has_base_url_ = true;
}




String URLPatternInit::getHashOr(const String& fallback_value) const {
  if (!hasHash()) {
  return fallback_value;
}
return member_hash_;
}

String URLPatternInit::getHashOr(String&& fallback_value) const {
  if (!hasHash()) {
  return std::move(fallback_value);
}
return member_hash_;
}

void URLPatternInit::setHash(const String& value) {
  member_hash_ = value;
has_hash_ = true;
}

void URLPatternInit::setHash(String&& value) {
  member_hash_ = std::move(value);
has_hash_ = true;
}




String URLPatternInit::getHostnameOr(const String& fallback_value) const {
  if (!hasHostname()) {
  return fallback_value;
}
return member_hostname_;
}

String URLPatternInit::getHostnameOr(String&& fallback_value) const {
  if (!hasHostname()) {
  return std::move(fallback_value);
}
return member_hostname_;
}

void URLPatternInit::setHostname(const String& value) {
  member_hostname_ = value;
has_hostname_ = true;
}

void URLPatternInit::setHostname(String&& value) {
  member_hostname_ = std::move(value);
has_hostname_ = true;
}




String URLPatternInit::getPasswordOr(const String& fallback_value) const {
  if (!hasPassword()) {
  return fallback_value;
}
return member_password_;
}

String URLPatternInit::getPasswordOr(String&& fallback_value) const {
  if (!hasPassword()) {
  return std::move(fallback_value);
}
return member_password_;
}

void URLPatternInit::setPassword(const String& value) {
  member_password_ = value;
has_password_ = true;
}

void URLPatternInit::setPassword(String&& value) {
  member_password_ = std::move(value);
has_password_ = true;
}




String URLPatternInit::getPathnameOr(const String& fallback_value) const {
  if (!hasPathname()) {
  return fallback_value;
}
return member_pathname_;
}

String URLPatternInit::getPathnameOr(String&& fallback_value) const {
  if (!hasPathname()) {
  return std::move(fallback_value);
}
return member_pathname_;
}

void URLPatternInit::setPathname(const String& value) {
  member_pathname_ = value;
has_pathname_ = true;
}

void URLPatternInit::setPathname(String&& value) {
  member_pathname_ = std::move(value);
has_pathname_ = true;
}




String URLPatternInit::getPortOr(const String& fallback_value) const {
  if (!hasPort()) {
  return fallback_value;
}
return member_port_;
}

String URLPatternInit::getPortOr(String&& fallback_value) const {
  if (!hasPort()) {
  return std::move(fallback_value);
}
return member_port_;
}

void URLPatternInit::setPort(const String& value) {
  member_port_ = value;
has_port_ = true;
}

void URLPatternInit::setPort(String&& value) {
  member_port_ = std::move(value);
has_port_ = true;
}




String URLPatternInit::getProtocolOr(const String& fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_;
}

String URLPatternInit::getProtocolOr(String&& fallback_value) const {
  if (!hasProtocol()) {
  return std::move(fallback_value);
}
return member_protocol_;
}

void URLPatternInit::setProtocol(const String& value) {
  member_protocol_ = value;
has_protocol_ = true;
}

void URLPatternInit::setProtocol(String&& value) {
  member_protocol_ = std::move(value);
has_protocol_ = true;
}




String URLPatternInit::getSearchOr(const String& fallback_value) const {
  if (!hasSearch()) {
  return fallback_value;
}
return member_search_;
}

String URLPatternInit::getSearchOr(String&& fallback_value) const {
  if (!hasSearch()) {
  return std::move(fallback_value);
}
return member_search_;
}

void URLPatternInit::setSearch(const String& value) {
  member_search_ = value;
has_search_ = true;
}

void URLPatternInit::setSearch(String&& value) {
  member_search_ = std::move(value);
has_search_ = true;
}




String URLPatternInit::getUsernameOr(const String& fallback_value) const {
  if (!hasUsername()) {
  return fallback_value;
}
return member_username_;
}

String URLPatternInit::getUsernameOr(String&& fallback_value) const {
  if (!hasUsername()) {
  return std::move(fallback_value);
}
return member_username_;
}

void URLPatternInit::setUsername(const String& value) {
  member_username_ = value;
has_username_ = true;
}

void URLPatternInit::setUsername(String&& value) {
  member_username_ = std::move(value);
has_username_ = true;
}



void URLPatternInit::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void URLPatternInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void URLPatternInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBaseURL()) {
  values[0] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_base_url_);
DCHECK(!values[0].IsEmpty());
}
if (hasHash()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_hash_);
DCHECK(!values[1].IsEmpty());
}
if (hasHostname()) {
  values[2] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_hostname_);
DCHECK(!values[2].IsEmpty());
}
if (hasPassword()) {
  values[3] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_password_);
DCHECK(!values[3].IsEmpty());
}
if (hasPathname()) {
  values[4] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_pathname_);
DCHECK(!values[4].IsEmpty());
}
if (hasPort()) {
  values[5] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_port_);
DCHECK(!values[5].IsEmpty());
}
if (hasProtocol()) {
  values[6] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_protocol_);
DCHECK(!values[6].IsEmpty());
}
if (hasSearch()) {
  values[7] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_search_);
DCHECK(!values[7].IsEmpty());
}
if (hasUsername()) {
  values[8] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_username_);
DCHECK(!values[8].IsEmpty());
}
}

const void* URLPatternInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> URLPatternInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void URLPatternInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "URLPatternInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("baseURL");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_base_url_, member_base_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hash");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_hash_, member_hash_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hostname");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_hostname_, member_hostname_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("password");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_password_, member_password_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pathname");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_pathname_, member_pathname_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("port");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_port_, member_port_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("protocol");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_protocol_, member_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("search");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_search_, member_search_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("username");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_username_, member_username_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> URLPatternInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
