// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_TASKPRIORITY_TASKSIGNAL_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_TASKPRIORITY_TASKSIGNAL_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_priority.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMTaskSignal;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionTaskPriorityOrTaskSignal final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kTaskPriority, kTaskSignal
};

static V8UnionTaskPriorityOrTaskSignal* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionTaskPriorityOrTaskSignal(V8TaskPriority value) : content_type_(ContentType::kTaskPriority), member_task_priority_(value) {
  
}
explicit  V8UnionTaskPriorityOrTaskSignal(DOMTaskSignal* value) : content_type_(ContentType::kTaskSignal), member_task_signal_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsTaskPriority() const {
  return content_type_ == ContentType::kTaskPriority;
}
V8TaskPriority GetAsTaskPriority() const {
  DCHECK_EQ(content_type_, ContentType::kTaskPriority);
return member_task_priority_;
}
void Set(V8TaskPriority value) {
  Clear();
member_task_priority_ = value;
content_type_ = ContentType::kTaskPriority;
}

bool IsTaskSignal() const {
  return content_type_ == ContentType::kTaskSignal;
}
DOMTaskSignal* GetAsTaskSignal() const {
  DCHECK_EQ(content_type_, ContentType::kTaskSignal);
return member_task_signal_.Get();
}
void Set(DOMTaskSignal* value) {
  DCHECK(value);
Clear();
member_task_signal_ = value;
content_type_ = ContentType::kTaskSignal;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(TaskPriority or TaskSignal)";
}

ContentType content_type_;

V8TaskPriority member_task_priority_{static_cast<V8TaskPriority::Enum>(0)};
Member<DOMTaskSignal> member_task_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_TASKPRIORITY_TASKSIGNAL_H_
