// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_unrestricteddoublesequence.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionStringOrUnrestrictedDoubleSequence* V8UnionStringOrUnrestrictedDoubleSequence::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<IDLUnrestrictedDouble>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrUnrestrictedDoubleSequence>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<IDLUnrestrictedDouble>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrUnrestrictedDoubleSequence>(std::move(blink_value));
}
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrUnrestrictedDoubleSequence>(std::move(blink_value));
}
}

 V8UnionStringOrUnrestrictedDoubleSequence::V8UnionStringOrUnrestrictedDoubleSequence(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionStringOrUnrestrictedDoubleSequence::V8UnionStringOrUnrestrictedDoubleSequence(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}

 V8UnionStringOrUnrestrictedDoubleSequence::V8UnionStringOrUnrestrictedDoubleSequence(const Vector<double>& value) : content_type_(ContentType::kUnrestrictedDoubleSequence), member_unrestricted_double_sequence_(value) {
  
}

 V8UnionStringOrUnrestrictedDoubleSequence::V8UnionStringOrUnrestrictedDoubleSequence(Vector<double>&& value) : content_type_(ContentType::kUnrestrictedDoubleSequence), member_unrestricted_double_sequence_(std::move(value)) {
  
}




void V8UnionStringOrUnrestrictedDoubleSequence::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionStringOrUnrestrictedDoubleSequence::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}



void V8UnionStringOrUnrestrictedDoubleSequence::Set(const Vector<double>& value) {
  Clear();
member_unrestricted_double_sequence_ = value;
content_type_ = ContentType::kUnrestrictedDoubleSequence;
}

void V8UnionStringOrUnrestrictedDoubleSequence::Set(Vector<double>&& value) {
  Clear();
member_unrestricted_double_sequence_ = std::move(value);
content_type_ = ContentType::kUnrestrictedDoubleSequence;
}


void V8UnionStringOrUnrestrictedDoubleSequence::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionStringOrUnrestrictedDoubleSequence::Clear() {
  member_string_ = String();
member_unrestricted_double_sequence_.clear();
}



}  // namespace blink
