// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_REQUEST_USVSTRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_REQUEST_USVSTRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class Request;
class ScriptState;

class CORE_EXPORT V8UnionRequestOrUSVString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kRequest, kUSVString
};

static V8UnionRequestOrUSVString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionRequestOrUSVString(Request* value) : content_type_(ContentType::kRequest), member_request_(value) {
  DCHECK(value);
}
explicit  V8UnionRequestOrUSVString(const String& value);
explicit  V8UnionRequestOrUSVString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsRequest() const {
  return content_type_ == ContentType::kRequest;
}
Request* GetAsRequest() const {
  DCHECK_EQ(content_type_, ContentType::kRequest);
return member_request_.Get();
}
void Set(Request* value) {
  DCHECK(value);
Clear();
member_request_ = value;
content_type_ = ContentType::kRequest;
}

bool IsUSVString() const {
  return content_type_ == ContentType::kUSVString;
}
const String& GetAsUSVString() const {
  DCHECK_EQ(content_type_, ContentType::kUSVString);
return member_usv_string_;
}
void Set(const String& value);
void Set(String&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Request or USVString)";
}

ContentType content_type_;

Member<Request> member_request_;
String member_usv_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_REQUEST_USVSTRING_H_
