// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FLOAT_STRINGELEMENTRECORD_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FLOAT_STRINGELEMENTRECORD_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class Element;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionFloatOrStringElementRecord final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kFloat, kStringElementRecord
};

static V8UnionFloatOrStringElementRecord* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionFloatOrStringElementRecord(float value) : content_type_(ContentType::kFloat), member_float_(value) {
  
}
explicit  V8UnionFloatOrStringElementRecord(const HeapVector<std::pair<String, Member<Element>>>& value);
explicit  V8UnionFloatOrStringElementRecord(HeapVector<std::pair<String, Member<Element>>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsFloat() const {
  return content_type_ == ContentType::kFloat;
}
float GetAsFloat() const {
  DCHECK_EQ(content_type_, ContentType::kFloat);
return member_float_;
}
void Set(float value) {
  Clear();
member_float_ = value;
content_type_ = ContentType::kFloat;
}

bool IsStringElementRecord() const {
  return content_type_ == ContentType::kStringElementRecord;
}
const HeapVector<std::pair<String, Member<Element>>>& GetAsStringElementRecord() const {
  DCHECK_EQ(content_type_, ContentType::kStringElementRecord);
return member_string_element_record_;
}
void Set(const HeapVector<std::pair<String, Member<Element>>>& value);
void Set(HeapVector<std::pair<String, Member<Element>>>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(float or record<DOMString, Element>)";
}

ContentType content_type_;

float member_float_;
HeapVector<std::pair<String, Member<Element>>> member_string_element_record_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_FLOAT_STRINGELEMENTRECORD_H_
