// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_doubleorstringortimelinerangeoffsetornullsequence_string_timelinerangeoffset_null.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_timeline_range_offset.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string_timelinerangeoffset.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_timelinerangeoffset.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull* V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = nullptr;
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(blink_value);
}
if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = TimelineRangeOffset::Create(isolate);
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(blink_value);
}
if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<IDLNullable<V8UnionDoubleOrStringOrTimelineRangeOffset>>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<IDLNullable<V8UnionDoubleOrStringOrTimelineRangeOffset>>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(std::move(blink_value));
}
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<TimelineRangeOffset>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(blink_value);
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull>(std::move(blink_value));
}
}

 V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(const HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>& value) : content_type_(ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence), member_double_or_string_or_timeline_range_offset_or_null_sequence_(value) {
  
}

 V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>&& value) : content_type_(ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence), member_double_or_string_or_timeline_range_offset_or_null_sequence_(std::move(value)) {
  
}

 V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(const HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>& value) {
  Clear();
member_double_or_string_or_timeline_range_offset_or_null_sequence_ = value;
content_type_ = ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence;
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(HeapVector<Member<V8UnionDoubleOrStringOrTimelineRangeOffset>>&& value) {
  Clear();
member_double_or_string_or_timeline_range_offset_or_null_sequence_ = std::move(value);
content_type_ = ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence;
}



void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}







V8UnionDoubleOrString* V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::GetAsV8UnionDoubleOrString() const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return MakeGarbageCollected<V8UnionDoubleOrString>(GetAsDouble());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionDoubleOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(const V8UnionDoubleOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionDoubleOrString::ContentType::kDouble: {
    Set(value->GetAsDouble());
    break;
  }
  case V8UnionDoubleOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionDoubleOrStringOrTimelineRangeOffset* V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::GetAsV8UnionDoubleOrStringOrTimelineRangeOffset() const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(GetAsDouble());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(GetAsString());
  }
  case ContentType::kTimelineRangeOffset: {
    return MakeGarbageCollected<V8UnionDoubleOrStringOrTimelineRangeOffset>(GetAsTimelineRangeOffset());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(const V8UnionDoubleOrStringOrTimelineRangeOffset* value) {
  switch (value->GetContentType()) {
  case V8UnionDoubleOrStringOrTimelineRangeOffset::ContentType::kDouble: {
    Set(value->GetAsDouble());
    break;
  }
  case V8UnionDoubleOrStringOrTimelineRangeOffset::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
  case V8UnionDoubleOrStringOrTimelineRangeOffset::ContentType::kTimelineRangeOffset: {
    Set(value->GetAsTimelineRangeOffset());
    break;
  }
}
}




V8UnionStringOrTimelineRangeOffset* V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::GetAsV8UnionStringOrTimelineRangeOffset() const {
  switch (content_type_) {
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionStringOrTimelineRangeOffset>(GetAsString());
  }
  case ContentType::kTimelineRangeOffset: {
    return MakeGarbageCollected<V8UnionStringOrTimelineRangeOffset>(GetAsTimelineRangeOffset());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Set(const V8UnionStringOrTimelineRangeOffset* value) {
  switch (value->GetContentType()) {
  case V8UnionStringOrTimelineRangeOffset::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
  case V8UnionStringOrTimelineRangeOffset::ContentType::kTimelineRangeOffset: {
    Set(value->GetAsTimelineRangeOffset());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return ToV8Traits<IDLDouble>::ToV8(script_state, member_double_);
  }
  case ContentType::kDoubleOrStringOrTimelineRangeOffsetOrNullSequence: {
    return ToV8Traits<IDLSequence<IDLNullable<V8UnionDoubleOrStringOrTimelineRangeOffset>>>::ToV8(script_state, member_double_or_string_or_timeline_range_offset_or_null_sequence_);
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kTimelineRangeOffset: {
    return ToV8Traits<TimelineRangeOffset>::ToV8(script_state, member_timeline_range_offset_.Get());
  }
  case ContentType::kNull: {
    return v8::Null(script_state->GetIsolate());
  }
}

NOTREACHED();
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Trace(Visitor* visitor) const {
  visitor->Trace(member_double_or_string_or_timeline_range_offset_or_null_sequence_);
visitor->Trace(member_timeline_range_offset_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionDoubleOrDoubleOrStringOrTimelineRangeOffsetOrNullSequenceOrStringOrTimelineRangeOffsetOrNull::Clear() {
  member_double_ = 0;
member_double_or_string_or_timeline_range_offset_or_null_sequence_.clear();
member_string_ = String();
member_timeline_range_offset_.Clear();
}



}  // namespace blink
