// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOMPOINTINIT_UNRESTRICTEDDOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOMPOINTINIT_UNRESTRICTEDDOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMPointInit;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionDOMPointInitOrUnrestrictedDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDOMPointInit, kUnrestrictedDouble
};

static V8UnionDOMPointInitOrUnrestrictedDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDOMPointInitOrUnrestrictedDouble(DOMPointInit* value) : content_type_(ContentType::kDOMPointInit), member_dom_point_init_(value) {
  DCHECK(value);
}
explicit  V8UnionDOMPointInitOrUnrestrictedDouble(double value) : content_type_(ContentType::kUnrestrictedDouble), member_unrestricted_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDOMPointInit() const {
  return content_type_ == ContentType::kDOMPointInit;
}
DOMPointInit* GetAsDOMPointInit() const {
  DCHECK_EQ(content_type_, ContentType::kDOMPointInit);
return member_dom_point_init_.Get();
}
void Set(DOMPointInit* value) {
  DCHECK(value);
Clear();
member_dom_point_init_ = value;
content_type_ = ContentType::kDOMPointInit;
}

bool IsUnrestrictedDouble() const {
  return content_type_ == ContentType::kUnrestrictedDouble;
}
double GetAsUnrestrictedDouble() const {
  DCHECK_EQ(content_type_, ContentType::kUnrestrictedDouble);
return member_unrestricted_double_;
}
void Set(double value) {
  Clear();
member_unrestricted_double_ = value;
content_type_ = ContentType::kUnrestrictedDouble;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMPointInit or unrestricted double)";
}

ContentType content_type_;

Member<DOMPointInit> member_dom_point_init_;
double member_unrestricted_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOMPOINTINIT_UNRESTRICTEDDOUBLE_H_
