// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_dommatrix_float32array_float64array.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix.h"
#include "third_party/blink/renderer/core/geometry/dom_matrix.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array* V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8DOMMatrix::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8DOMMatrix::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array>(blink_value);
}
if (v8_value->IsFloat32Array()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMFloat32Array>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array>(blink_value);
}
if (v8_value->IsFloat64Array()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMFloat64Array>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













void V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array::Trace(Visitor* visitor) const {
  visitor->Trace(member_dom_matrix_);
visitor->Trace(member_float32_array_);
visitor->Trace(member_float64_array_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionDOMMatrixOrFloat32ArrayOrFloat64Array::Clear() {
  member_dom_matrix_.Clear();
member_float32_array_.Clear();
member_float64_array_.Clear();
}



}  // namespace blink
