// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_csspseudoelement_element.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_pseudo_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/core/dom/css_pseudo_element.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionCSSPseudoElementOrElement* V8UnionCSSPseudoElementOrElement::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8Element::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Element::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionCSSPseudoElementOrElement>(blink_value);
}
if (V8CSSPseudoElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8CSSPseudoElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionCSSPseudoElementOrElement>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionCSSPseudoElementOrElement::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kCSSPseudoElement: {
    return ToV8Traits<CSSPseudoElement>::ToV8(script_state, member_css_pseudo_element_.Get());
  }
  case ContentType::kElement: {
    return ToV8Traits<Element>::ToV8(script_state, member_element_.Get());
  }
}

NOTREACHED();
}

void V8UnionCSSPseudoElementOrElement::Trace(Visitor* visitor) const {
  visitor->Trace(member_css_pseudo_element_);
visitor->Trace(member_element_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionCSSPseudoElementOrElement::Clear() {
  member_css_pseudo_element_.Clear();
member_element_.Clear();
}



}  // namespace blink
