// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSNUMERICVALUE_DOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSNUMERICVALUE_DOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CSSNumericValue;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionCSSNumericValueOrDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kCSSNumericValue, kDouble
};

static V8UnionCSSNumericValueOrDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionCSSNumericValueOrDouble(CSSNumericValue* value) : content_type_(ContentType::kCSSNumericValue), member_css_numeric_value_(value) {
  DCHECK(value);
}
explicit  V8UnionCSSNumericValueOrDouble(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsCSSNumericValue() const {
  return content_type_ == ContentType::kCSSNumericValue;
}
CSSNumericValue* GetAsCSSNumericValue() const {
  DCHECK_EQ(content_type_, ContentType::kCSSNumericValue);
return member_css_numeric_value_.Get();
}
void Set(CSSNumericValue* value) {
  DCHECK(value);
Clear();
member_css_numeric_value_ = value;
content_type_ = ContentType::kCSSNumericValue;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(CSSNumericValue or double)";
}

ContentType content_type_;

Member<CSSNumericValue> member_css_numeric_value_;
double member_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CSSNUMERICVALUE_DOUBLE_H_
