// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BOOLEAN_STRING_UNRESTRICTEDDOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BOOLEAN_STRING_UNRESTRICTEDDOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;
class V8UnionBooleanOrString;

class CORE_EXPORT V8UnionBooleanOrStringOrUnrestrictedDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kBoolean, kString, kUnrestrictedDouble
};

static V8UnionBooleanOrStringOrUnrestrictedDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionBooleanOrStringOrUnrestrictedDouble(bool value) : content_type_(ContentType::kBoolean), member_boolean_(value) {
  
}
explicit  V8UnionBooleanOrStringOrUnrestrictedDouble(const String& value);
explicit  V8UnionBooleanOrStringOrUnrestrictedDouble(String&& value);
explicit  V8UnionBooleanOrStringOrUnrestrictedDouble(double value) : content_type_(ContentType::kUnrestrictedDouble), member_unrestricted_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsBoolean() const {
  return content_type_ == ContentType::kBoolean;
}
bool GetAsBoolean() const {
  DCHECK_EQ(content_type_, ContentType::kBoolean);
return member_boolean_;
}
void Set(bool value) {
  Clear();
member_boolean_ = value;
content_type_ = ContentType::kBoolean;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsUnrestrictedDouble() const {
  return content_type_ == ContentType::kUnrestrictedDouble;
}
double GetAsUnrestrictedDouble() const {
  DCHECK_EQ(content_type_, ContentType::kUnrestrictedDouble);
return member_unrestricted_double_;
}
void Set(double value) {
  Clear();
member_unrestricted_double_ = value;
content_type_ = ContentType::kUnrestrictedDouble;
}

bool IsV8UnionBooleanOrString() const {
  return content_type_ == ContentType::kBoolean || content_type_ == ContentType::kString;
}
V8UnionBooleanOrString* GetAsV8UnionBooleanOrString() const;
void Set(const V8UnionBooleanOrString* value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or boolean or unrestricted double)";
}

ContentType content_type_;

bool member_boolean_;
String member_string_;
double member_unrestricted_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BOOLEAN_STRING_UNRESTRICTEDDOUBLE_H_
