// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_AUDIOTRACK_TEXTTRACK_VIDEOTRACK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_AUDIOTRACK_TEXTTRACK_VIDEOTRACK_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioTrack;
class ExceptionState;
class ScriptState;
class TextTrack;
class VideoTrack;

class CORE_EXPORT V8UnionAudioTrackOrTextTrackOrVideoTrack final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAudioTrack, kTextTrack, kVideoTrack
};

static V8UnionAudioTrackOrTextTrackOrVideoTrack* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAudioTrackOrTextTrackOrVideoTrack(AudioTrack* value) : content_type_(ContentType::kAudioTrack), member_audio_track_(value) {
  DCHECK(value);
}
explicit  V8UnionAudioTrackOrTextTrackOrVideoTrack(TextTrack* value) : content_type_(ContentType::kTextTrack), member_text_track_(value) {
  DCHECK(value);
}
explicit  V8UnionAudioTrackOrTextTrackOrVideoTrack(VideoTrack* value) : content_type_(ContentType::kVideoTrack), member_video_track_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAudioTrack() const {
  return content_type_ == ContentType::kAudioTrack;
}
AudioTrack* GetAsAudioTrack() const {
  DCHECK_EQ(content_type_, ContentType::kAudioTrack);
return member_audio_track_.Get();
}
void Set(AudioTrack* value) {
  DCHECK(value);
Clear();
member_audio_track_ = value;
content_type_ = ContentType::kAudioTrack;
}

bool IsTextTrack() const {
  return content_type_ == ContentType::kTextTrack;
}
TextTrack* GetAsTextTrack() const {
  DCHECK_EQ(content_type_, ContentType::kTextTrack);
return member_text_track_.Get();
}
void Set(TextTrack* value) {
  DCHECK(value);
Clear();
member_text_track_ = value;
content_type_ = ContentType::kTextTrack;
}

bool IsVideoTrack() const {
  return content_type_ == ContentType::kVideoTrack;
}
VideoTrack* GetAsVideoTrack() const {
  DCHECK_EQ(content_type_, ContentType::kVideoTrack);
return member_video_track_.Get();
}
void Set(VideoTrack* value) {
  DCHECK(value);
Clear();
member_video_track_ = value;
content_type_ = ContentType::kVideoTrack;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AudioTrack or TextTrack or VideoTrack)";
}

ContentType content_type_;

Member<AudioTrack> member_audio_track_;
Member<TextTrack> member_text_track_;
Member<VideoTrack> member_video_track_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_AUDIOTRACK_TEXTTRACK_VIDEOTRACK_H_
