// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_animationeffect_animationeffectsequence.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_animation_effect.h"
#include "third_party/blink/renderer/core/animation/animation_effect.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionAnimationEffectOrAnimationEffectSequence* V8UnionAnimationEffectOrAnimationEffectSequence::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8AnimationEffect::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8AnimationEffect::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionAnimationEffectOrAnimationEffectSequence>(blink_value);
}
if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<AnimationEffect>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionAnimationEffectOrAnimationEffectSequence>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<AnimationEffect>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionAnimationEffectOrAnimationEffectSequence>(std::move(blink_value));
}
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}

 V8UnionAnimationEffectOrAnimationEffectSequence::V8UnionAnimationEffectOrAnimationEffectSequence(const HeapVector<Member<AnimationEffect>>& value) : content_type_(ContentType::kAnimationEffectSequence), member_animation_effect_sequence_(value) {
  
}

 V8UnionAnimationEffectOrAnimationEffectSequence::V8UnionAnimationEffectOrAnimationEffectSequence(HeapVector<Member<AnimationEffect>>&& value) : content_type_(ContentType::kAnimationEffectSequence), member_animation_effect_sequence_(std::move(value)) {
  
}







void V8UnionAnimationEffectOrAnimationEffectSequence::Set(const HeapVector<Member<AnimationEffect>>& value) {
  Clear();
member_animation_effect_sequence_ = value;
content_type_ = ContentType::kAnimationEffectSequence;
}

void V8UnionAnimationEffectOrAnimationEffectSequence::Set(HeapVector<Member<AnimationEffect>>&& value) {
  Clear();
member_animation_effect_sequence_ = std::move(value);
content_type_ = ContentType::kAnimationEffectSequence;
}


void V8UnionAnimationEffectOrAnimationEffectSequence::Trace(Visitor* visitor) const {
  visitor->Trace(member_animation_effect_);
visitor->Trace(member_animation_effect_sequence_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionAnimationEffectOrAnimationEffectSequence::Clear() {
  member_animation_effect_.Clear();
member_animation_effect_sequence_.clear();
}



}  // namespace blink
