// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOOL_REGISTRATION_PARAMS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOOL_REGISTRATION_PARAMS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AnnotationsDict;
class ExceptionState;
class V8ToolFunction;

class CORE_EXPORT ToolRegistrationParams : public bindings::InputDictionaryBase {
  
  public:
static ToolRegistrationParams* Create() {
  return MakeGarbageCollected<ToolRegistrationParams>();
}
static ToolRegistrationParams* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ToolRegistrationParams>(isolate);
}
static ToolRegistrationParams* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ToolRegistrationParams();
explicit  ToolRegistrationParams(v8::Isolate* isolate);

bool hasAnnotations() const {
  return has_annotations_;
}
AnnotationsDict* annotations() const {
  DCHECK(hasAnnotations());
return member_annotations_.Get();
}
AnnotationsDict* getAnnotationsOr(AnnotationsDict* fallback_value) const {
  if (!hasAnnotations()) {
  return fallback_value;
}
return member_annotations_.Get();
}
void setAnnotations(AnnotationsDict* value) {
  member_annotations_ = value;
has_annotations_ = true;
DCHECK(member_annotations_);
}

bool hasDescription() const {
  return true;
}
const String& description() const {
  return member_description_;
}
void setDescription(const String& value);
void setDescription(String&& value);

bool hasExecute() const {
  return true;
}
V8ToolFunction* execute() const {
  return member_execute_.Get();
}
void setExecute(V8ToolFunction* value) {
  member_execute_ = value;
DCHECK(member_execute_);
}

bool hasInputSchema() const {
  return has_input_schema_;
}
const ScriptObject& inputSchema() const {
  DCHECK(hasInputSchema());
return member_input_schema_;
}
ScriptObject getInputSchemaOr(const ScriptObject& fallback_value) const {
  if (!hasInputSchema()) {
  return fallback_value;
}
return member_input_schema_;
}
void setInputSchema(const ScriptObject& value) {
  member_input_schema_ = value;
has_input_schema_ = true;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_annotations_ = false;
bool has_input_schema_ = false;

Member<AnnotationsDict> member_annotations_;
String member_description_;
Member<V8ToolFunction> member_execute_;
ScriptObject member_input_schema_;
String member_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOOL_REGISTRATION_PARAMS_H_
