// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TEXT_DIRECTIVE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TEXT_DIRECTIVE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT TextDirectiveOptions : public bindings::InputDictionaryBase {
  
  public:
static TextDirectiveOptions* Create() {
  return MakeGarbageCollected<TextDirectiveOptions>();
}
static TextDirectiveOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TextDirectiveOptions>(isolate);
}
static TextDirectiveOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TextDirectiveOptions();
explicit  TextDirectiveOptions(v8::Isolate* isolate);

bool hasPrefix() const {
  return has_prefix_;
}
const String& prefix() const {
  DCHECK(hasPrefix());
return member_prefix_;
}
String getPrefixOr(const String& fallback_value) const;
String getPrefixOr(String&& fallback_value) const;
void setPrefix(const String& value);
void setPrefix(String&& value);

bool hasSuffix() const {
  return has_suffix_;
}
const String& suffix() const {
  DCHECK(hasSuffix());
return member_suffix_;
}
String getSuffixOr(const String& fallback_value) const;
String getSuffixOr(String&& fallback_value) const;
void setSuffix(const String& value);
void setSuffix(String&& value);

bool hasTextEnd() const {
  return has_text_end_;
}
const String& textEnd() const {
  DCHECK(hasTextEnd());
return member_text_end_;
}
String getTextEndOr(const String& fallback_value) const;
String getTextEndOr(String&& fallback_value) const;
void setTextEnd(const String& value);
void setTextEnd(String&& value);

bool hasTextStart() const {
  return has_text_start_;
}
const String& textStart() const {
  DCHECK(hasTextStart());
return member_text_start_;
}
String getTextStartOr(const String& fallback_value) const;
String getTextStartOr(String&& fallback_value) const;
void setTextStart(const String& value);
void setTextStart(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_prefix_ = false;
bool has_suffix_ = false;
bool has_text_end_ = false;
bool has_text_start_ = false;

String member_prefix_;
String member_suffix_;
String member_text_end_;
String member_text_start_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TEXT_DIRECTIVE_OPTIONS_H_
