// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHARED_WORKER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHARED_WORKER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_shared_worker_same_site_cookies.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_options.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT SharedWorkerOptions : public WorkerOptions {
  
  public:
static SharedWorkerOptions* Create() {
  return MakeGarbageCollected<SharedWorkerOptions>();
}
static SharedWorkerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SharedWorkerOptions>(isolate);
}
static SharedWorkerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SharedWorkerOptions();
explicit  SharedWorkerOptions(v8::Isolate* isolate);

bool hasExtendedLifetime() const {
  return has_extended_lifetime_;
}
bool extendedLifetime() const {
  DCHECK(hasExtendedLifetime());
return member_extended_lifetime_;
}
bool getExtendedLifetimeOr(bool fallback_value) const {
  if (!hasExtendedLifetime()) {
  return fallback_value;
}
return member_extended_lifetime_;
}
void setExtendedLifetime(bool value) {
  member_extended_lifetime_ = value;
has_extended_lifetime_ = true;
}

bool hasSameSiteCookies() const {
  return has_same_site_cookies_;
}
V8SharedWorkerSameSiteCookies sameSiteCookies() const {
  DCHECK(hasSameSiteCookies());
return member_same_site_cookies_;
}
V8SharedWorkerSameSiteCookies getSameSiteCookiesOr(V8SharedWorkerSameSiteCookies fallback_value) const {
  if (!hasSameSiteCookies()) {
  return fallback_value;
}
return member_same_site_cookies_;
}
void setSameSiteCookies(V8SharedWorkerSameSiteCookies value) {
  member_same_site_cookies_ = value;
has_same_site_cookies_ = true;
}
void setSameSiteCookies(V8SharedWorkerSameSiteCookies::Enum value) {
  member_same_site_cookies_ = V8SharedWorkerSameSiteCookies(value);
has_same_site_cookies_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = WorkerOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_extended_lifetime_ = false;
bool has_same_site_cookies_ = false;

bool member_extended_lifetime_;
V8SharedWorkerSameSiteCookies member_same_site_cookies_{static_cast<V8SharedWorkerSameSiteCookies::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHARED_WORKER_OPTIONS_H_
