// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PAGE_TRANSITION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PAGE_TRANSITION_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PageTransitionEventInit : public EventInit {
  
  public:
static PageTransitionEventInit* Create() {
  return MakeGarbageCollected<PageTransitionEventInit>();
}
static PageTransitionEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PageTransitionEventInit>(isolate);
}
static PageTransitionEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PageTransitionEventInit();
explicit  PageTransitionEventInit(v8::Isolate* isolate);

bool hasPersisted() const {
  return has_persisted_;
}
bool persisted() const {
  DCHECK(hasPersisted());
return member_persisted_;
}
bool getPersistedOr(bool fallback_value) const {
  if (!hasPersisted()) {
  return fallback_value;
}
return member_persisted_;
}
void setPersisted(bool value) {
  member_persisted_ = value;
has_persisted_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_persisted_ = false;

bool member_persisted_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PAGE_TRANSITION_EVENT_INIT_H_
