// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_OPTIONAL_EFFECT_TIMING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_OPTIONAL_EFFECT_TIMING_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_fill_mode.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_playback_direction.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CSSNumericValue;
class ExceptionState;
class V8UnionCSSNumericValueOrDouble;
class V8UnionCSSNumericValueOrStringOrUnrestrictedDouble;

class CORE_EXPORT OptionalEffectTiming : public bindings::InputDictionaryBase {
  
  public:
static OptionalEffectTiming* Create() {
  return MakeGarbageCollected<OptionalEffectTiming>();
}
static OptionalEffectTiming* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<OptionalEffectTiming>(isolate);
}
static OptionalEffectTiming* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  OptionalEffectTiming();
explicit  OptionalEffectTiming(v8::Isolate* isolate);

bool hasDelay() const {
  return has_delay_;
}
V8UnionCSSNumericValueOrDouble* delay() const {
  DCHECK(hasDelay());
return member_delay_.Get();
}
V8UnionCSSNumericValueOrDouble* getDelayOr(V8UnionCSSNumericValueOrDouble* fallback_value) const {
  if (!hasDelay()) {
  return fallback_value;
}
return member_delay_.Get();
}
void setDelay(V8UnionCSSNumericValueOrDouble* value) {
  member_delay_ = value;
has_delay_ = true;
DCHECK(member_delay_);
}

bool hasDirection() const {
  return has_direction_;
}
V8PlaybackDirection direction() const {
  DCHECK(hasDirection());
return member_direction_;
}
V8PlaybackDirection getDirectionOr(V8PlaybackDirection fallback_value) const {
  if (!hasDirection()) {
  return fallback_value;
}
return member_direction_;
}
void setDirection(V8PlaybackDirection value) {
  member_direction_ = value;
has_direction_ = true;
}
void setDirection(V8PlaybackDirection::Enum value) {
  member_direction_ = V8PlaybackDirection(value);
has_direction_ = true;
}

bool hasDuration() const {
  return has_duration_;
}
V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* duration() const {
  DCHECK(hasDuration());
return member_duration_.Get();
}
V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* getDurationOr(V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* fallback_value) const {
  if (!hasDuration()) {
  return fallback_value;
}
return member_duration_.Get();
}
void setDuration(V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* value) {
  member_duration_ = value;
has_duration_ = true;
DCHECK(member_duration_);
}

bool hasEasing() const {
  return has_easing_;
}
const String& easing() const {
  DCHECK(hasEasing());
return member_easing_;
}
String getEasingOr(const String& fallback_value) const;
String getEasingOr(String&& fallback_value) const;
void setEasing(const String& value);
void setEasing(String&& value);

bool hasEndDelay() const {
  return has_end_delay_;
}
V8UnionCSSNumericValueOrDouble* endDelay() const {
  DCHECK(hasEndDelay());
return member_end_delay_.Get();
}
V8UnionCSSNumericValueOrDouble* getEndDelayOr(V8UnionCSSNumericValueOrDouble* fallback_value) const {
  if (!hasEndDelay()) {
  return fallback_value;
}
return member_end_delay_.Get();
}
void setEndDelay(V8UnionCSSNumericValueOrDouble* value) {
  member_end_delay_ = value;
has_end_delay_ = true;
DCHECK(member_end_delay_);
}

bool hasFill() const {
  return has_fill_;
}
V8FillMode fill() const {
  DCHECK(hasFill());
return member_fill_;
}
V8FillMode getFillOr(V8FillMode fallback_value) const {
  if (!hasFill()) {
  return fallback_value;
}
return member_fill_;
}
void setFill(V8FillMode value) {
  member_fill_ = value;
has_fill_ = true;
}
void setFill(V8FillMode::Enum value) {
  member_fill_ = V8FillMode(value);
has_fill_ = true;
}

bool hasIterationStart() const {
  return has_iteration_start_;
}
double iterationStart() const {
  DCHECK(hasIterationStart());
return member_iteration_start_;
}
double getIterationStartOr(double fallback_value) const {
  if (!hasIterationStart()) {
  return fallback_value;
}
return member_iteration_start_;
}
void setIterationStart(double value) {
  member_iteration_start_ = value;
has_iteration_start_ = true;
}

bool hasIterations() const {
  return has_iterations_;
}
double iterations() const {
  DCHECK(hasIterations());
return member_iterations_;
}
double getIterationsOr(double fallback_value) const {
  if (!hasIterations()) {
  return fallback_value;
}
return member_iterations_;
}
void setIterations(double value) {
  member_iterations_ = value;
has_iterations_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_delay_ = false;
bool has_direction_ = false;
bool has_duration_ = false;
bool has_easing_ = false;
bool has_end_delay_ = false;
bool has_fill_ = false;
bool has_iteration_start_ = false;
bool has_iterations_ = false;

Member<V8UnionCSSNumericValueOrDouble> member_delay_;
V8PlaybackDirection member_direction_{static_cast<V8PlaybackDirection::Enum>(0)};
Member<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble> member_duration_;
String member_easing_;
Member<V8UnionCSSNumericValueOrDouble> member_end_delay_;
V8FillMode member_fill_{static_cast<V8FillMode::Enum>(0)};
double member_iteration_start_;
double member_iterations_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_OPTIONAL_EFFECT_TIMING_H_
