// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_optional_effect_timing.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_double.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_string_unrestricteddouble.h"
#include "third_party/blink/renderer/core/css/cssom/css_numeric_value.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"delay",
"direction",
"duration",
"easing",
"endDelay",
"fill",
"iterationStart",
"iterations",
};


}  // namespace 

OptionalEffectTiming* OptionalEffectTiming::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  OptionalEffectTiming* dictionary = MakeGarbageCollected<OptionalEffectTiming>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "OptionalEffectTiming";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 OptionalEffectTiming::OptionalEffectTiming() {
  
}

 OptionalEffectTiming::OptionalEffectTiming(v8::Isolate* isolate) {
  
}
























String OptionalEffectTiming::getEasingOr(const String& fallback_value) const {
  if (!hasEasing()) {
  return fallback_value;
}
return member_easing_;
}

String OptionalEffectTiming::getEasingOr(String&& fallback_value) const {
  if (!hasEasing()) {
  return std::move(fallback_value);
}
return member_easing_;
}

void OptionalEffectTiming::setEasing(const String& value) {
  member_easing_ = value;
has_easing_ = true;
}

void OptionalEffectTiming::setEasing(String&& value) {
  member_easing_ = std::move(value);
has_easing_ = true;
}































void OptionalEffectTiming::Trace(Visitor* visitor) const {
  visitor->Trace(member_delay_);
visitor->Trace(member_duration_);
visitor->Trace(member_end_delay_);
bindings::InputDictionaryBase::Trace(visitor);
}

void OptionalEffectTiming::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "OptionalEffectTiming";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("delay");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_delay_, member_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("direction");
if (!bindings::GetDictionaryMemberFromV8Object<V8PlaybackDirection, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_direction_, member_direction_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("duration");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_duration_, member_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("easing");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_easing_, member_easing_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("endDelay");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_end_delay_, member_end_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fill");
if (!bindings::GetDictionaryMemberFromV8Object<V8FillMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_fill_, member_fill_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iterationStart");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_iteration_start_, member_iteration_start_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iterations");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_iterations_, member_iterations_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> OptionalEffectTiming::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
