// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_NAVIGATE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_NAVIGATE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigation_history_behavior.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigation_options.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT NavigationNavigateOptions : public NavigationOptions {
  
  public:
static NavigationNavigateOptions* Create() {
  return MakeGarbageCollected<NavigationNavigateOptions>();
}
static NavigationNavigateOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NavigationNavigateOptions>(isolate);
}
static NavigationNavigateOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NavigationNavigateOptions();
explicit  NavigationNavigateOptions(v8::Isolate* isolate);

bool hasHistory() const {
  return true;
}
V8NavigationHistoryBehavior history() const {
  return member_history_;
}
void setHistory(V8NavigationHistoryBehavior value) {
  member_history_ = value;
}
void setHistory(V8NavigationHistoryBehavior::Enum value) {
  member_history_ = V8NavigationHistoryBehavior(value);
}

bool hasState() const {
  return !member_state_.IsEmpty();
}
const ScriptValue& state() const {
  DCHECK(hasState());
return member_state_;
}
ScriptValue getStateOr(const ScriptValue& fallback_value) const {
  if (!hasState()) {
  return fallback_value;
}
return member_state_;
}
void setState(const ScriptValue& value) {
  member_state_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = NavigationOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8NavigationHistoryBehavior member_history_{V8NavigationHistoryBehavior::Enum::kAuto};
ScriptValue member_state_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_NAVIGATE_OPTIONS_H_
