// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_INTERFACE_REQUEST_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_INTERFACE_REQUEST_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MojoHandle;

class CORE_EXPORT MojoInterfaceRequestEventInit : public EventInit {
  
  public:
static MojoInterfaceRequestEventInit* Create() {
  return MakeGarbageCollected<MojoInterfaceRequestEventInit>();
}
static MojoInterfaceRequestEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MojoInterfaceRequestEventInit>(isolate);
}
static MojoInterfaceRequestEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MojoInterfaceRequestEventInit();
explicit  MojoInterfaceRequestEventInit(v8::Isolate* isolate);

bool hasHandle() const {
  return has_handle_;
}
MojoHandle* handle() const {
  DCHECK(hasHandle());
return member_handle_.Get();
}
MojoHandle* getHandleOr(MojoHandle* fallback_value) const {
  if (!hasHandle()) {
  return fallback_value;
}
return member_handle_.Get();
}
void setHandle(MojoHandle* value) {
  member_handle_ = value;
has_handle_ = true;
DCHECK(member_handle_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_handle_ = false;

Member<MojoHandle> member_handle_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_INTERFACE_REQUEST_EVENT_INIT_H_
