// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_mojo.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/core/context_features/context_feature_settings.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/mojo/mojo.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8Mojo::IsExposed(ExecutionContext* execution_context) {
  
const ContextFeatureSettings* context_feature_settings = ContextFeatureSettings::From(execution_context, ContextFeatureSettings::CreationMode::kDontCreateIfNotExists);
return (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && RuntimeEnabledFeatures::MojoJSEnabled() && (context_feature_settings && context_feature_settings->isMojoJSEnabled());
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8Mojo::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8Mojo::InstallInterfaceTemplate,
    V8Mojo::InstallContextDependentProperties,
    "Mojo",
    nullptr,
    V8Mojo::kThisTag,
    V8Mojo::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& Mojo::wrapper_type_info_ =
    V8Mojo::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, Mojo>::value,
    "Mojo inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

// Cross-component trampolines
V8Mojo::InstallInterfaceTemplateFuncType V8Mojo::install_interface_template_func_ = nullptr;
V8Mojo::InstallUnconditionalPropertiesFuncType V8Mojo::install_unconditional_props_func_ = nullptr;
V8Mojo::InstallContextDependentPropertiesFuncType V8Mojo::install_context_dependent_props_func_ = nullptr;


}  // namespace blink
