// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_highlight_hit_result.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/dom/abstract_range.h"
#include "third_party/blink/renderer/core/highlight/highlight.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"highlight",
"ranges",
};


}  // namespace 

HighlightHitResult* HighlightHitResult::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  HighlightHitResult* dictionary = MakeGarbageCollected<HighlightHitResult>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "HighlightHitResult";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 HighlightHitResult::HighlightHitResult() {
  
}

 HighlightHitResult::HighlightHitResult(v8::Isolate* isolate) {
  
}










HeapVector<Member<AbstractRange>> HighlightHitResult::getRangesOr(const HeapVector<Member<AbstractRange>>& fallback_value) const {
  if (!hasRanges()) {
  return fallback_value;
}
return member_ranges_;
}

HeapVector<Member<AbstractRange>> HighlightHitResult::getRangesOr(HeapVector<Member<AbstractRange>>&& fallback_value) const {
  if (!hasRanges()) {
  return std::move(fallback_value);
}
return member_ranges_;
}

void HighlightHitResult::setRanges(const HeapVector<Member<AbstractRange>>& value) {
  member_ranges_ = value;
has_ranges_ = true;
}

void HighlightHitResult::setRanges(HeapVector<Member<AbstractRange>>&& value) {
  member_ranges_ = std::move(value);
has_ranges_ = true;
}



void HighlightHitResult::Trace(Visitor* visitor) const {
  visitor->Trace(member_highlight_);
visitor->Trace(member_ranges_);
bindings::DictionaryBase::Trace(visitor);
}

void HighlightHitResult::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void HighlightHitResult::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasHighlight()) {
  values[0] = ToV8Traits<Highlight>::ToV8(script_state, member_highlight_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasRanges()) {
  values[1] = ToV8Traits<IDLSequence<AbstractRange>>::ToV8(script_state, member_ranges_);
DCHECK(!values[1].IsEmpty());
}
}

const void* HighlightHitResult::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> HighlightHitResult::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void HighlightHitResult::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "HighlightHitResult";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("highlight");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<Highlight, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_highlight_, member_highlight_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ranges");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AbstractRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_ranges_, member_ranges_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> HighlightHitResult::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
