// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_hash_change_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"newURL",
"oldURL",
};


}  // namespace 

HashChangeEventInit* HashChangeEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  HashChangeEventInit* dictionary = MakeGarbageCollected<HashChangeEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "HashChangeEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 HashChangeEventInit::HashChangeEventInit() {
  
}

 HashChangeEventInit::HashChangeEventInit(v8::Isolate* isolate) : EventInit(isolate) {
  
}



String HashChangeEventInit::getNewURLOr(const String& fallback_value) const {
  if (!hasNewURL()) {
  return fallback_value;
}
return member_new_url_;
}

String HashChangeEventInit::getNewURLOr(String&& fallback_value) const {
  if (!hasNewURL()) {
  return std::move(fallback_value);
}
return member_new_url_;
}

void HashChangeEventInit::setNewURL(const String& value) {
  member_new_url_ = value;
has_new_url_ = true;
}

void HashChangeEventInit::setNewURL(String&& value) {
  member_new_url_ = std::move(value);
has_new_url_ = true;
}




String HashChangeEventInit::getOldURLOr(const String& fallback_value) const {
  if (!hasOldURL()) {
  return fallback_value;
}
return member_old_url_;
}

String HashChangeEventInit::getOldURLOr(String&& fallback_value) const {
  if (!hasOldURL()) {
  return std::move(fallback_value);
}
return member_old_url_;
}

void HashChangeEventInit::setOldURL(const String& value) {
  member_old_url_ = value;
has_old_url_ = true;
}

void HashChangeEventInit::setOldURL(String&& value) {
  member_old_url_ = std::move(value);
has_old_url_ = true;
}



void HashChangeEventInit::Trace(Visitor* visitor) const {
  EventInit::Trace(visitor);
}

void HashChangeEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "HashChangeEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("newURL");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_new_url_, member_new_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("oldURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_old_url_, member_old_url_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> HashChangeEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
