// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FRAGMENT_RESULT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FRAGMENT_RESULT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CustomLayoutFragment;
class ExceptionState;

class CORE_EXPORT FragmentResultOptions : public bindings::DictionaryBase {
  
  public:
static FragmentResultOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FragmentResultOptions>(isolate);
}
static FragmentResultOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FragmentResultOptions(v8::Isolate* isolate);

bool hasAutoBlockSize() const {
  return true;
}
double autoBlockSize() const {
  return member_auto_block_size_;
}
void setAutoBlockSize(double value) {
  member_auto_block_size_ = value;
}

bool hasBaseline() const {
  return has_baseline_;
}
double baseline() const {
  DCHECK(hasBaseline());
return member_baseline_;
}
double getBaselineOr(double fallback_value) const {
  if (!hasBaseline()) {
  return fallback_value;
}
return member_baseline_;
}
void setBaseline(double value) {
  member_baseline_ = value;
has_baseline_ = true;
}

bool hasChildFragments() const {
  return true;
}
const HeapVector<Member<CustomLayoutFragment>>& childFragments() const {
  return member_child_fragments_;
}
void setChildFragments(const HeapVector<Member<CustomLayoutFragment>>& value);
void setChildFragments(HeapVector<Member<CustomLayoutFragment>>&& value);

bool hasData() const {
  return true;
}
const ScriptValue& data() const {
  return member_data_;
}
void setData(const ScriptValue& value) {
  member_data_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_baseline_ = false;

double member_auto_block_size_{0};
double member_baseline_;
HeapVector<Member<CustomLayoutFragment>> member_child_fragments_;
ScriptValue member_data_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FRAGMENT_RESULT_OPTIONS_H_
