// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_font_face_descriptors.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"ascentOverride",
"descentOverride",
"display",
"featureSettings",
"lineGapOverride",
"sizeAdjust",
"stretch",
"style",
"unicodeRange",
"variant",
"variationSettings",
"weight",
};


}  // namespace 

FontFaceDescriptors* FontFaceDescriptors::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  FontFaceDescriptors* dictionary = MakeGarbageCollected<FontFaceDescriptors>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "FontFaceDescriptors";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 FontFaceDescriptors::FontFaceDescriptors() {
  
}

 FontFaceDescriptors::FontFaceDescriptors(v8::Isolate* isolate) {
  
}



void FontFaceDescriptors::setAscentOverride(const String& value) {
  member_ascent_override_ = value;
}

void FontFaceDescriptors::setAscentOverride(String&& value) {
  member_ascent_override_ = std::move(value);
}




void FontFaceDescriptors::setDescentOverride(const String& value) {
  member_descent_override_ = value;
}

void FontFaceDescriptors::setDescentOverride(String&& value) {
  member_descent_override_ = std::move(value);
}




void FontFaceDescriptors::setDisplay(const String& value) {
  member_display_ = value;
}

void FontFaceDescriptors::setDisplay(String&& value) {
  member_display_ = std::move(value);
}




void FontFaceDescriptors::setFeatureSettings(const String& value) {
  member_feature_settings_ = value;
}

void FontFaceDescriptors::setFeatureSettings(String&& value) {
  member_feature_settings_ = std::move(value);
}




void FontFaceDescriptors::setLineGapOverride(const String& value) {
  member_line_gap_override_ = value;
}

void FontFaceDescriptors::setLineGapOverride(String&& value) {
  member_line_gap_override_ = std::move(value);
}




void FontFaceDescriptors::setSizeAdjust(const String& value) {
  member_size_adjust_ = value;
}

void FontFaceDescriptors::setSizeAdjust(String&& value) {
  member_size_adjust_ = std::move(value);
}




void FontFaceDescriptors::setStretch(const String& value) {
  member_stretch_ = value;
}

void FontFaceDescriptors::setStretch(String&& value) {
  member_stretch_ = std::move(value);
}




void FontFaceDescriptors::setStyle(const String& value) {
  member_style_ = value;
}

void FontFaceDescriptors::setStyle(String&& value) {
  member_style_ = std::move(value);
}




void FontFaceDescriptors::setUnicodeRange(const String& value) {
  member_unicode_range_ = value;
}

void FontFaceDescriptors::setUnicodeRange(String&& value) {
  member_unicode_range_ = std::move(value);
}




void FontFaceDescriptors::setVariant(const String& value) {
  member_variant_ = value;
}

void FontFaceDescriptors::setVariant(String&& value) {
  member_variant_ = std::move(value);
}




void FontFaceDescriptors::setVariationSettings(const String& value) {
  member_variation_settings_ = value;
}

void FontFaceDescriptors::setVariationSettings(String&& value) {
  member_variation_settings_ = std::move(value);
}




void FontFaceDescriptors::setWeight(const String& value) {
  member_weight_ = value;
}

void FontFaceDescriptors::setWeight(String&& value) {
  member_weight_ = std::move(value);
}



void FontFaceDescriptors::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void FontFaceDescriptors::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "FontFaceDescriptors";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("ascentOverride");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_ascent_override_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("descentOverride");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_descent_override_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("display");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_display_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("featureSettings");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_feature_settings_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lineGapOverride");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_line_gap_override_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sizeAdjust");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_size_adjust_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stretch");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_stretch_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("style");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_style_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unicodeRange");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_unicode_range_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("variant");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_variant_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FontVariationSettingsDescriptorEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("variationSettings");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_variation_settings_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("weight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), fallback_presence_var, member_weight_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> FontFaceDescriptors::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
