// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_fence_event.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"crossOriginExposed",
"destination",
"destinationURL",
"eventData",
"eventType",
"once",
};


}  // namespace 

FenceEvent* FenceEvent::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  FenceEvent* dictionary = MakeGarbageCollected<FenceEvent>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "FenceEvent";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 FenceEvent::FenceEvent() {
  
}

 FenceEvent::FenceEvent(v8::Isolate* isolate) {
  
}








Vector<V8FenceReportingDestination> FenceEvent::getDestinationOr(const Vector<V8FenceReportingDestination>& fallback_value) const {
  if (!hasDestination()) {
  return fallback_value;
}
return member_destination_;
}

Vector<V8FenceReportingDestination> FenceEvent::getDestinationOr(Vector<V8FenceReportingDestination>&& fallback_value) const {
  if (!hasDestination()) {
  return std::move(fallback_value);
}
return member_destination_;
}

void FenceEvent::setDestination(const Vector<V8FenceReportingDestination>& value) {
  member_destination_ = value;
has_destination_ = true;
}

void FenceEvent::setDestination(Vector<V8FenceReportingDestination>&& value) {
  member_destination_ = std::move(value);
has_destination_ = true;
}




String FenceEvent::getDestinationURLOr(const String& fallback_value) const {
  if (!hasDestinationURL()) {
  return fallback_value;
}
return member_destination_url_;
}

String FenceEvent::getDestinationURLOr(String&& fallback_value) const {
  if (!hasDestinationURL()) {
  return std::move(fallback_value);
}
return member_destination_url_;
}

void FenceEvent::setDestinationURL(const String& value) {
  member_destination_url_ = value;
has_destination_url_ = true;
}

void FenceEvent::setDestinationURL(String&& value) {
  member_destination_url_ = std::move(value);
has_destination_url_ = true;
}




String FenceEvent::getEventDataOr(const String& fallback_value) const {
  if (!hasEventData()) {
  return fallback_value;
}
return member_event_data_;
}

String FenceEvent::getEventDataOr(String&& fallback_value) const {
  if (!hasEventData()) {
  return std::move(fallback_value);
}
return member_event_data_;
}

void FenceEvent::setEventData(const String& value) {
  member_event_data_ = value;
has_event_data_ = true;
}

void FenceEvent::setEventData(String&& value) {
  member_event_data_ = std::move(value);
has_event_data_ = true;
}




String FenceEvent::getEventTypeOr(const String& fallback_value) const {
  if (!hasEventType()) {
  return fallback_value;
}
return member_event_type_;
}

String FenceEvent::getEventTypeOr(String&& fallback_value) const {
  if (!hasEventType()) {
  return std::move(fallback_value);
}
return member_event_type_;
}

void FenceEvent::setEventType(const String& value) {
  member_event_type_ = value;
has_event_type_ = true;
}

void FenceEvent::setEventType(String&& value) {
  member_event_type_ = std::move(value);
has_event_type_ = true;
}








void FenceEvent::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void FenceEvent::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "FenceEvent";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("crossOriginExposed");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_cross_origin_exposed_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("destination");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8FenceReportingDestination>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_destination_, member_destination_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("destinationURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_destination_url_, member_destination_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("eventData");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_event_data_, member_event_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("eventType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_event_type_, member_event_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("once");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_once_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> FenceEvent::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
