// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ERROR_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ERROR_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ErrorEventInit : public EventInit {
  
  public:
static ErrorEventInit* Create() {
  return MakeGarbageCollected<ErrorEventInit>();
}
static ErrorEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ErrorEventInit>(isolate);
}
static ErrorEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ErrorEventInit();
explicit  ErrorEventInit(v8::Isolate* isolate);

bool hasColno() const {
  return true;
}
uint32_t colno() const {
  return member_colno_;
}
void setColno(uint32_t value) {
  member_colno_ = value;
}

bool hasError() const {
  return !member_error_.IsEmpty();
}
const ScriptValue& error() const {
  DCHECK(hasError());
return member_error_;
}
ScriptValue getErrorOr(const ScriptValue& fallback_value) const {
  if (!hasError()) {
  return fallback_value;
}
return member_error_;
}
void setError(const ScriptValue& value) {
  member_error_ = value;
}

bool hasFilename() const {
  return true;
}
const String& filename() const {
  return member_filename_;
}
void setFilename(const String& value);
void setFilename(String&& value);

bool hasLineno() const {
  return true;
}
uint32_t lineno() const {
  return member_lineno_;
}
void setLineno(uint32_t value) {
  member_lineno_ = value;
}

bool hasMessage() const {
  return true;
}
const String& message() const {
  return member_message_;
}
void setMessage(const String& value);
void setMessage(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_colno_{0};
ScriptValue member_error_;
String member_filename_{""};
uint32_t member_lineno_{0};
String member_message_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ERROR_EVENT_INIT_H_
