// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_QUAD_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_QUAD_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMPointInit;
class ExceptionState;

class CORE_EXPORT DOMQuadInit : public bindings::InputDictionaryBase {
  
  public:
static DOMQuadInit* Create() {
  return MakeGarbageCollected<DOMQuadInit>();
}
static DOMQuadInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DOMQuadInit>(isolate);
}
static DOMQuadInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DOMQuadInit();
explicit  DOMQuadInit(v8::Isolate* isolate);

bool hasP1() const {
  return has_p_1_;
}
DOMPointInit* p1() const {
  DCHECK(hasP1());
return member_p_1_.Get();
}
DOMPointInit* getP1Or(DOMPointInit* fallback_value) const {
  if (!hasP1()) {
  return fallback_value;
}
return member_p_1_.Get();
}
void setP1(DOMPointInit* value) {
  member_p_1_ = value;
has_p_1_ = true;
DCHECK(member_p_1_);
}

bool hasP2() const {
  return has_p_2_;
}
DOMPointInit* p2() const {
  DCHECK(hasP2());
return member_p_2_.Get();
}
DOMPointInit* getP2Or(DOMPointInit* fallback_value) const {
  if (!hasP2()) {
  return fallback_value;
}
return member_p_2_.Get();
}
void setP2(DOMPointInit* value) {
  member_p_2_ = value;
has_p_2_ = true;
DCHECK(member_p_2_);
}

bool hasP3() const {
  return has_p_3_;
}
DOMPointInit* p3() const {
  DCHECK(hasP3());
return member_p_3_.Get();
}
DOMPointInit* getP3Or(DOMPointInit* fallback_value) const {
  if (!hasP3()) {
  return fallback_value;
}
return member_p_3_.Get();
}
void setP3(DOMPointInit* value) {
  member_p_3_ = value;
has_p_3_ = true;
DCHECK(member_p_3_);
}

bool hasP4() const {
  return has_p_4_;
}
DOMPointInit* p4() const {
  DCHECK(hasP4());
return member_p_4_.Get();
}
DOMPointInit* getP4Or(DOMPointInit* fallback_value) const {
  if (!hasP4()) {
  return fallback_value;
}
return member_p_4_.Get();
}
void setP4(DOMPointInit* value) {
  member_p_4_ = value;
has_p_4_ = true;
DCHECK(member_p_4_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_p_1_ = false;
bool has_p_2_ = false;
bool has_p_3_ = false;
bool has_p_4_ = false;

Member<DOMPointInit> member_p_1_;
Member<DOMPointInit> member_p_2_;
Member<DOMPointInit> member_p_3_;
Member<DOMPointInit> member_p_4_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_QUAD_INIT_H_
