// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_EXCEPTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_EXCEPTION_H_

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/v8_interface_bridge.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {

class DOMException;
class ExecutionContext;
struct WrapperTypeInfo;

class CORE_EXPORT V8DOMException final : public bindings::V8InterfaceBridge<V8DOMException, DOMException> {
  
  public:
// Constants
class Constant final {
  STATIC_ONLY(Constant);

  public:
static constexpr uint16_t kIndexSizeErr = 1;
static constexpr uint16_t kDomstringSizeErr = 2;
static constexpr uint16_t kHierarchyRequestErr = 3;
static constexpr uint16_t kWrongDocumentErr = 4;
static constexpr uint16_t kInvalidCharacterErr = 5;
static constexpr uint16_t kNoDataAllowedErr = 6;
static constexpr uint16_t kNoModificationAllowedErr = 7;
static constexpr uint16_t kNotFoundErr = 8;
static constexpr uint16_t kNotSupportedErr = 9;
static constexpr uint16_t kInuseAttributeErr = 10;
static constexpr uint16_t kInvalidStateErr = 11;
static constexpr uint16_t kSyntaxErr = 12;
static constexpr uint16_t kInvalidModificationErr = 13;
static constexpr uint16_t kNamespaceErr = 14;
static constexpr uint16_t kInvalidAccessErr = 15;
static constexpr uint16_t kValidationErr = 16;
static constexpr uint16_t kTypeMismatchErr = 17;
static constexpr uint16_t kSecurityErr = 18;
static constexpr uint16_t kNetworkErr = 19;
static constexpr uint16_t kAbortErr = 20;
static constexpr uint16_t kUrlMismatchErr = 21;
static constexpr uint16_t kQuotaExceededErr = 22;
static constexpr uint16_t kTimeoutErr = 23;
static constexpr uint16_t kInvalidNodeTypeErr = 24;
static constexpr uint16_t kDataCloneErr = 25;

  
  
  
};

static bool IsExposed(ExecutionContext* execution_context);

static constexpr const WrapperTypeInfo* GetWrapperTypeInfo() {
  return &wrapper_type_info_;
}
  static_assert(static_cast<v8::CppHeapPointerTag>(356) <
                 blink::kLastScriptWrappableTag,
                 "There are more ScriptWrappable types than available type tags."
                 "You have to increase the kLastScirptWrappableTag in wrapper_type_info.h");
  static constexpr v8::CppHeapPointerTag kThisTag =
      static_cast<v8::CppHeapPointerTag>(356);
  static constexpr v8::CppHeapPointerTag kMaxSubclassTag =
      static_cast<v8::CppHeapPointerTag>(364);
  static constexpr v8::CppHeapPointerTagRange kTagRange =
      v8::CppHeapPointerTagRange(kThisTag, kMaxSubclassTag);


static void InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template);
static void InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template);


  
  private:
static const WrapperTypeInfo wrapper_type_info_;


  friend class DOMException;
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_EXCEPTION_H_
