// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ARIA_NOTIFICATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ARIA_NOTIFICATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_aria_notify_interrupt.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_aria_notify_priority.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT AriaNotificationOptions : public bindings::InputDictionaryBase {
  
  public:
static AriaNotificationOptions* Create() {
  return MakeGarbageCollected<AriaNotificationOptions>();
}
static AriaNotificationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AriaNotificationOptions>(isolate);
}
static AriaNotificationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AriaNotificationOptions();
explicit  AriaNotificationOptions(v8::Isolate* isolate);

bool hasInterrupt() const {
  return true;
}
V8AriaNotifyInterrupt interrupt() const {
  return member_interrupt_;
}
void setInterrupt(V8AriaNotifyInterrupt value) {
  member_interrupt_ = value;
}
void setInterrupt(V8AriaNotifyInterrupt::Enum value) {
  member_interrupt_ = V8AriaNotifyInterrupt(value);
}

bool hasPriority() const {
  return true;
}
V8AriaNotifyPriority priority() const {
  return member_priority_;
}
void setPriority(V8AriaNotifyPriority value) {
  member_priority_ = value;
}
void setPriority(V8AriaNotifyPriority::Enum value) {
  member_priority_ = V8AriaNotifyPriority(value);
}

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8AriaNotifyInterrupt member_interrupt_{V8AriaNotifyInterrupt::Enum::kNone};
V8AriaNotifyPriority member_priority_{V8AriaNotifyPriority::Enum::kNormal};
String member_type_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ARIA_NOTIFICATION_OPTIONS_H_
