// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ANNOTATIONS_DICT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ANNOTATIONS_DICT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT AnnotationsDict : public bindings::InputDictionaryBase {
  
  public:
static AnnotationsDict* Create() {
  return MakeGarbageCollected<AnnotationsDict>();
}
static AnnotationsDict* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AnnotationsDict>(isolate);
}
static AnnotationsDict* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AnnotationsDict();
explicit  AnnotationsDict(v8::Isolate* isolate);

bool hasReadOnlyHint() const {
  return has_read_only_hint_;
}
bool readOnlyHint() const {
  DCHECK(hasReadOnlyHint());
return member_read_only_hint_;
}
bool getReadOnlyHintOr(bool fallback_value) const {
  if (!hasReadOnlyHint()) {
  return fallback_value;
}
return member_read_only_hint_;
}
void setReadOnlyHint(bool value) {
  member_read_only_hint_ = value;
has_read_only_hint_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_read_only_hint_ = false;

bool member_read_only_hint_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ANNOTATIONS_DICT_H_
