// third_party/blink/public/mojom/worker/worker_options.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/worker/worker_options.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var script_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/script/script_type.mojom', '../script/script_type.mojom.js');
  }



  function WorkerOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkerOptions.prototype.initDefaults_ = function() {
    this.type = script_type$.ScriptType.kClassic;
    this.credentials = fetch_api$.CredentialsMode.kSameOrigin;
    this.name = "";
  };
  WorkerOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkerOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkerOptions.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, script_type$.ScriptType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkerOptions.credentials
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, fetch_api$.CredentialsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkerOptions.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WorkerOptions.encodedSize = codec.kStructHeaderSize + 16;

  WorkerOptions.decode = function(decoder) {
    var packed;
    var val = new WorkerOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(script_type$.ScriptType));
    val.credentials =
        decoder.decodeStruct(new codec.Enum(fetch_api$.CredentialsMode));
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WorkerOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkerOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.credentials);
    encoder.encodeStruct(codec.String, val.name);
  };
  exports.WorkerOptions = WorkerOptions;
})();