// third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_MAIN_SCRIPT_LOAD_PARAMS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_MAIN_SCRIPT_LOAD_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader.mojom-blink.h"
#include "services/network/public/mojom/url_response_head.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT WorkerMainScriptLoadParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WorkerMainScriptLoadParams, T>::value>;
  using DataView = WorkerMainScriptLoadParamsDataView;
  using Data_ = internal::WorkerMainScriptLoadParams_Data;

  template <typename... Args>
  static WorkerMainScriptLoadParamsPtr New(Args&&... args) {
    return WorkerMainScriptLoadParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WorkerMainScriptLoadParamsPtr From(const U& u) {
    return mojo::TypeConverter<WorkerMainScriptLoadParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WorkerMainScriptLoadParams>::Convert(*this);
  }


  WorkerMainScriptLoadParams();

  WorkerMainScriptLoadParams(
      int32_t request_id,
      ::network::mojom::blink::URLResponseHeadPtr response_head,
      ::mojo::ScopedDataPipeConsumerHandle response_body,
      ::network::mojom::blink::URLLoaderClientEndpointsPtr url_loader_client_endpoints,
      ::blink::Vector<::network::mojom::blink::URLRequestRedirectInfoPtr> redirect_infos,
      ::blink::Vector<::network::mojom::blink::URLResponseHeadPtr> redirect_response_heads);

WorkerMainScriptLoadParams(const WorkerMainScriptLoadParams&) = delete;
WorkerMainScriptLoadParams& operator=(const WorkerMainScriptLoadParams&) = delete;

  ~WorkerMainScriptLoadParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WorkerMainScriptLoadParamsPtr>
  WorkerMainScriptLoadParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WorkerMainScriptLoadParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WorkerMainScriptLoadParams_UnserializedMessageContext<
            UserType, WorkerMainScriptLoadParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WorkerMainScriptLoadParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WorkerMainScriptLoadParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WorkerMainScriptLoadParams_UnserializedMessageContext<
            UserType, WorkerMainScriptLoadParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WorkerMainScriptLoadParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t request_id;
  
  ::network::mojom::blink::URLResponseHeadPtr response_head;
  
  ::mojo::ScopedDataPipeConsumerHandle response_body;
  
  ::network::mojom::blink::URLLoaderClientEndpointsPtr url_loader_client_endpoints;
  
  ::blink::Vector<::network::mojom::blink::URLRequestRedirectInfoPtr> redirect_infos;
  
  ::blink::Vector<::network::mojom::blink::URLResponseHeadPtr> redirect_response_heads;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WorkerMainScriptLoadParamsPtr WorkerMainScriptLoadParams::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(response_head),
      mojo::Clone(response_body),
      mojo::Clone(url_loader_client_endpoints),
      mojo::Clone(redirect_infos),
      mojo::Clone(redirect_response_heads)
  );
}

template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>*>
bool WorkerMainScriptLoadParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->response_head, other_struct.response_head))
    return false;
  if (!mojo::Equals(this->response_body, other_struct.response_body))
    return false;
  if (!mojo::Equals(this->url_loader_client_endpoints, other_struct.url_loader_client_endpoints))
    return false;
  if (!mojo::Equals(this->redirect_infos, other_struct.redirect_infos))
    return false;
  if (!mojo::Equals(this->redirect_response_heads, other_struct.redirect_response_heads))
    return false;
  return true;
}

template <typename T, WorkerMainScriptLoadParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.response_head < rhs.response_head)
    return true;
  if (rhs.response_head < lhs.response_head)
    return false;
  if (lhs.response_body < rhs.response_body)
    return true;
  if (rhs.response_body < lhs.response_body)
    return false;
  if (lhs.url_loader_client_endpoints < rhs.url_loader_client_endpoints)
    return true;
  if (rhs.url_loader_client_endpoints < lhs.url_loader_client_endpoints)
    return false;
  if (lhs.redirect_infos < rhs.redirect_infos)
    return true;
  if (rhs.redirect_infos < lhs.redirect_infos)
    return false;
  if (lhs.redirect_response_heads < rhs.redirect_response_heads)
    return true;
  if (rhs.redirect_response_heads < lhs.redirect_response_heads)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WorkerMainScriptLoadParams::DataView,
                                         ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WorkerMainScriptLoadParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::WorkerMainScriptLoadParams::request_id) request_id(
      const ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) {
    return input->request_id;
  }

  static const decltype(::blink::mojom::blink::WorkerMainScriptLoadParams::response_head)& response_head(
      const ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) {
    return input->response_head;
  }

  static  decltype(::blink::mojom::blink::WorkerMainScriptLoadParams::response_body)& response_body(
       ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) {
    return input->response_body;
  }

  static  decltype(::blink::mojom::blink::WorkerMainScriptLoadParams::url_loader_client_endpoints)& url_loader_client_endpoints(
       ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) {
    return input->url_loader_client_endpoints;
  }

  static const decltype(::blink::mojom::blink::WorkerMainScriptLoadParams::redirect_infos)& redirect_infos(
      const ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) {
    return input->redirect_infos;
  }

  static const decltype(::blink::mojom::blink::WorkerMainScriptLoadParams::redirect_response_heads)& redirect_response_heads(
      const ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr& input) {
    return input->redirect_response_heads;
  }

  static bool Read(::blink::mojom::blink::WorkerMainScriptLoadParams::DataView input, ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_MAIN_SCRIPT_LOAD_PARAMS_MOJOM_BLINK_H_