// third_party/blink/public/mojom/worker/shared_worker_factory.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');




/**
 * @const { !string }
 * @export
 */
blink.mojom.NAVIGATION_SHARED_WORKER_SPEC = "navigation:shared_worker";





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedWorkerFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedWorkerFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedWorkerFactoryInterface }
 */
blink.mojom.SharedWorkerFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedWorkerFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedWorkerFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedWorkerFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.SharedWorkerInfo } info
   * @param { !blink.mojom.SharedWorkerToken } token
   * @param { !blink.mojom.StorageKey } constructorKey
   * @param { !url.mojom.Origin } origin
   * @param { !boolean } isConstructorSecureContext
   * @param { !string } userAgent
   * @param { !blink.mojom.UserAgentMetadata } uaMetadata
   * @param { !boolean } pauseOnStart
   * @param { !mojoBase.mojom.UnguessableToken } devtoolsWorkerToken
   * @param { !blink.mojom.RendererPreferences } rendererPreferences
   * @param { !blink.mojom.RendererPreferenceWatcherPendingReceiver } preferenceWatcherReceiver
   * @param { !blink.mojom.WorkerContentSettingsProxyRemote } contentSettings
   * @param { ?blink.mojom.ServiceWorkerContainerInfoForClient } serviceWorkerContainerInfo
   * @param { !blink.mojom.WorkerMainScriptLoadParams } mainScriptLoadParams
   * @param { !blink.mojom.URLLoaderFactoryBundle } subresourceLoaderFactories
   * @param { ?blink.mojom.ControllerServiceWorkerInfo } controllerInfo
   * @param { !blink.mojom.PolicyContainer } policyContainer
   * @param { !blink.mojom.SharedWorkerHostRemote } host
   * @param { !blink.mojom.SharedWorkerPendingReceiver } sharedWorker
   * @param { !blink.mojom.BrowserInterfaceBrokerRemote } browserInterfaceBroker
   * @param { !bigint } ukmSourceId
   * @param { !boolean } requireCrossSiteRequestForCookies
   * @param { ?blink.mojom.ReportingObserverPendingReceiver } coepReportingObserverReceiver
   * @param { ?blink.mojom.ReportingObserverPendingReceiver } dipReportingObserverReceiver
   */

  createSharedWorker(
      info,
      token,
      constructorKey,
      origin,
      isConstructorSecureContext,
      userAgent,
      uaMetadata,
      pauseOnStart,
      devtoolsWorkerToken,
      rendererPreferences,
      preferenceWatcherReceiver,
      contentSettings,
      serviceWorkerContainerInfo,
      mainScriptLoadParams,
      subresourceLoaderFactories,
      controllerInfo,
      policyContainer,
      host,
      sharedWorker,
      browserInterfaceBroker,
      ukmSourceId,
      requireCrossSiteRequestForCookies,
      coepReportingObserverReceiver,
      dipReportingObserverReceiver) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
        null,
        [
          info,
          token,
          constructorKey,
          origin,
          isConstructorSecureContext,
          userAgent,
          uaMetadata,
          pauseOnStart,
          devtoolsWorkerToken,
          rendererPreferences,
          preferenceWatcherReceiver,
          contentSettings,
          serviceWorkerContainerInfo,
          mainScriptLoadParams,
          subresourceLoaderFactories,
          controllerInfo,
          policyContainer,
          host,
          sharedWorker,
          browserInterfaceBroker,
          ukmSourceId,
          requireCrossSiteRequestForCookies,
          coepReportingObserverReceiver,
          dipReportingObserverReceiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedWorkerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedWorkerFactoryReceiver = class {
  /**
   * @param {!blink.mojom.SharedWorkerFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedWorkerFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedWorkerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
        null,
        impl.createSharedWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedWorkerFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedWorkerFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedWorkerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedWorkerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedWorkerFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedWorkerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSharedWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
        null,
        this.createSharedWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerFactory_CreateSharedWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedWorkerFactory_CreateSharedWorker_ParamsSpec.$,
    'SharedWorkerFactory_CreateSharedWorker_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink.mojom.SharedWorkerInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        blink.mojom.SharedWorkerTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'constructorKey', 16,
        0,
        blink.mojom.StorageKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 24,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isConstructorSecureContext', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userAgent', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uaMetadata', 48,
        0,
        blink.mojom.UserAgentMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pauseOnStart', 32,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsWorkerToken', 56,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rendererPreferences', 64,
        0,
        blink.mojom.RendererPreferencesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferenceWatcherReceiver', 36,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.RendererPreferenceWatcherPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentSettings', 72,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.WorkerContentSettingsProxyRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerContainerInfo', 80,
        0,
        blink.mojom.ServiceWorkerContainerInfoForClientSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mainScriptLoadParams', 88,
        0,
        blink.mojom.WorkerMainScriptLoadParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceLoaderFactories', 96,
        0,
        blink.mojom.URLLoaderFactoryBundleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controllerInfo', 104,
        0,
        blink.mojom.ControllerServiceWorkerInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyContainer', 112,
        0,
        blink.mojom.PolicyContainerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 120,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SharedWorkerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedWorker', 128,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.SharedWorkerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browserInterfaceBroker', 132,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BrowserInterfaceBrokerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ukmSourceId', 144,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireCrossSiteRequestForCookies', 32,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'coepReportingObserverReceiver', 140,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dipReportingObserverReceiver', 152,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 168],]);





/** @record */
blink.mojom.SharedWorkerFactory_CreateSharedWorker_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedWorkerInfo } */
    this.info;
    /** @export { !blink.mojom.SharedWorkerToken } */
    this.token;
    /** @export { !blink.mojom.StorageKey } */
    this.constructorKey;
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !boolean } */
    this.isConstructorSecureContext;
    /** @export { !string } */
    this.userAgent;
    /** @export { !blink.mojom.UserAgentMetadata } */
    this.uaMetadata;
    /** @export { !boolean } */
    this.pauseOnStart;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsWorkerToken;
    /** @export { !blink.mojom.RendererPreferences } */
    this.rendererPreferences;
    /** @export { !blink.mojom.RendererPreferenceWatcherPendingReceiver } */
    this.preferenceWatcherReceiver;
    /** @export { !blink.mojom.WorkerContentSettingsProxyRemote } */
    this.contentSettings;
    /** @export { (blink.mojom.ServiceWorkerContainerInfoForClient|undefined) } */
    this.serviceWorkerContainerInfo;
    /** @export { !blink.mojom.WorkerMainScriptLoadParams } */
    this.mainScriptLoadParams;
    /** @export { !blink.mojom.URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
    /** @export { (blink.mojom.ControllerServiceWorkerInfo|undefined) } */
    this.controllerInfo;
    /** @export { !blink.mojom.PolicyContainer } */
    this.policyContainer;
    /** @export { !blink.mojom.SharedWorkerHostRemote } */
    this.host;
    /** @export { !blink.mojom.SharedWorkerPendingReceiver } */
    this.sharedWorker;
    /** @export { !blink.mojom.BrowserInterfaceBrokerRemote } */
    this.browserInterfaceBroker;
    /** @export { !bigint } */
    this.ukmSourceId;
    /** @export { !boolean } */
    this.requireCrossSiteRequestForCookies;
    /** @export { (blink.mojom.ReportingObserverPendingReceiver|undefined) } */
    this.coepReportingObserverReceiver;
    /** @export { (blink.mojom.ReportingObserverPendingReceiver|undefined) } */
    this.dipReportingObserverReceiver;
  }
};

