// third_party/blink/public/mojom/worker/shared_worker.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.MessagePortDescriptor');






goog.provide('blink.mojom.SharedWorker');
goog.provide('blink.mojom.SharedWorkerReceiver');
goog.provide('blink.mojom.SharedWorkerCallbackRouter');
goog.provide('blink.mojom.SharedWorkerInterface');
goog.provide('blink.mojom.SharedWorkerRemote');
goog.provide('blink.mojom.SharedWorkerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedWorkerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedWorker.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SharedWorkerInterface = class {
  
  /**
   * @param { !number } connectionId
   * @param { !blink.mojom.MessagePortDescriptor } messagePort
   */

  connect(connectionId, messagePort) {}
  
  /**
   */

  terminate() {}
};

/**
 * @export
 * @implements { blink.mojom.SharedWorkerInterface }
 */
blink.mojom.SharedWorkerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } connectionId
   * @param { !blink.mojom.MessagePortDescriptor } messagePort
   */

  connect(
      connectionId,
      messagePort) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedWorker_Connect_ParamsSpec.$,
        null,
        [
          connectionId,
          messagePort
        ],
        false);
  }

  
  /**
   */

  terminate() {
    this.proxy.sendMessage(
        1,
        blink.mojom.SharedWorker_Terminate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedWorkerReceiver = class {
  /**
   * @param {!blink.mojom.SharedWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorker_Connect_ParamsSpec.$,
        null,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedWorker_Terminate_ParamsSpec.$,
        null,
        impl.terminate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedWorker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedWorkerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedWorkerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorker_Connect_ParamsSpec.$,
        null,
        this.connect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.terminate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedWorker_Terminate_ParamsSpec.$,
        null,
        this.terminate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SharedWorker_Connect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorker_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SharedWorker_Terminate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorker_Terminate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedWorker_Connect_ParamsSpec.$,
    'SharedWorker_Connect_Params',
    [
      mojo.internal.StructField(
        'connectionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'messagePort', 8,
        0,
        blink.mojom.MessagePortDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SharedWorker_Connect_Params');

/** @record */
blink.mojom.SharedWorker_Connect_Params = class {
  constructor() {
    /** @export { !number } */
    this.connectionId;
    /** @export { !blink.mojom.MessagePortDescriptor } */
    this.messagePort;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorker_Terminate_ParamsSpec.$,
    'SharedWorker_Terminate_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SharedWorker_Terminate_Params');

/** @record */
blink.mojom.SharedWorker_Terminate_Params = class {
  constructor() {
  }
};

