// third_party/blink/public/mojom/widget/record_content_to_visible_time_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_RECORD_CONTENT_TO_VISIBLE_TIME_REQUEST_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_RECORD_CONTENT_TO_VISIBLE_TIME_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/widget/record_content_to_visible_time_request.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/record_content_to_visible_time_request.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/record_content_to_visible_time_request.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT RecordContentToVisibleTimeRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RecordContentToVisibleTimeRequest, T>::value>;
  using DataView = RecordContentToVisibleTimeRequestDataView;
  using Data_ = internal::RecordContentToVisibleTimeRequest_Data;

  template <typename... Args>
  static RecordContentToVisibleTimeRequestPtr New(Args&&... args) {
    return RecordContentToVisibleTimeRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RecordContentToVisibleTimeRequestPtr From(const U& u) {
    return mojo::TypeConverter<RecordContentToVisibleTimeRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RecordContentToVisibleTimeRequest>::Convert(*this);
  }


  RecordContentToVisibleTimeRequest();

  RecordContentToVisibleTimeRequest(
      ::base::TimeTicks event_start_time,
      bool destination_is_loaded,
      bool show_reason_tab_switching,
      bool show_reason_bfcache_restore,
      bool show_reason_unfolding);


  ~RecordContentToVisibleTimeRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RecordContentToVisibleTimeRequestPtr>
  RecordContentToVisibleTimeRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RecordContentToVisibleTimeRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RecordContentToVisibleTimeRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RecordContentToVisibleTimeRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RecordContentToVisibleTimeRequest_UnserializedMessageContext<
            UserType, RecordContentToVisibleTimeRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RecordContentToVisibleTimeRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RecordContentToVisibleTimeRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RecordContentToVisibleTimeRequest_UnserializedMessageContext<
            UserType, RecordContentToVisibleTimeRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RecordContentToVisibleTimeRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks event_start_time;
  
  bool destination_is_loaded;
  
  bool show_reason_tab_switching;
  
  bool show_reason_bfcache_restore;
  
  bool show_reason_unfolding;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RecordContentToVisibleTimeRequestPtr RecordContentToVisibleTimeRequest::Clone() const {
  return New(
      mojo::Clone(event_start_time),
      mojo::Clone(destination_is_loaded),
      mojo::Clone(show_reason_tab_switching),
      mojo::Clone(show_reason_bfcache_restore),
      mojo::Clone(show_reason_unfolding)
  );
}

template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>*>
bool RecordContentToVisibleTimeRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->event_start_time, other_struct.event_start_time))
    return false;
  if (!mojo::Equals(this->destination_is_loaded, other_struct.destination_is_loaded))
    return false;
  if (!mojo::Equals(this->show_reason_tab_switching, other_struct.show_reason_tab_switching))
    return false;
  if (!mojo::Equals(this->show_reason_bfcache_restore, other_struct.show_reason_bfcache_restore))
    return false;
  if (!mojo::Equals(this->show_reason_unfolding, other_struct.show_reason_unfolding))
    return false;
  return true;
}

template <typename T, RecordContentToVisibleTimeRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.event_start_time < rhs.event_start_time)
    return true;
  if (rhs.event_start_time < lhs.event_start_time)
    return false;
  if (lhs.destination_is_loaded < rhs.destination_is_loaded)
    return true;
  if (rhs.destination_is_loaded < lhs.destination_is_loaded)
    return false;
  if (lhs.show_reason_tab_switching < rhs.show_reason_tab_switching)
    return true;
  if (rhs.show_reason_tab_switching < lhs.show_reason_tab_switching)
    return false;
  if (lhs.show_reason_bfcache_restore < rhs.show_reason_bfcache_restore)
    return true;
  if (rhs.show_reason_bfcache_restore < lhs.show_reason_bfcache_restore)
    return false;
  if (lhs.show_reason_unfolding < rhs.show_reason_unfolding)
    return true;
  if (rhs.show_reason_unfolding < lhs.show_reason_unfolding)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RecordContentToVisibleTimeRequest::DataView,
                                         ::blink::mojom::RecordContentToVisibleTimeRequestPtr> {
  static bool IsNull(const ::blink::mojom::RecordContentToVisibleTimeRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RecordContentToVisibleTimeRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::RecordContentToVisibleTimeRequest::event_start_time)& event_start_time(
      const ::blink::mojom::RecordContentToVisibleTimeRequestPtr& input) {
    return input->event_start_time;
  }

  static decltype(::blink::mojom::RecordContentToVisibleTimeRequest::destination_is_loaded) destination_is_loaded(
      const ::blink::mojom::RecordContentToVisibleTimeRequestPtr& input) {
    return input->destination_is_loaded;
  }

  static decltype(::blink::mojom::RecordContentToVisibleTimeRequest::show_reason_tab_switching) show_reason_tab_switching(
      const ::blink::mojom::RecordContentToVisibleTimeRequestPtr& input) {
    return input->show_reason_tab_switching;
  }

  static decltype(::blink::mojom::RecordContentToVisibleTimeRequest::show_reason_bfcache_restore) show_reason_bfcache_restore(
      const ::blink::mojom::RecordContentToVisibleTimeRequestPtr& input) {
    return input->show_reason_bfcache_restore;
  }

  static decltype(::blink::mojom::RecordContentToVisibleTimeRequest::show_reason_unfolding) show_reason_unfolding(
      const ::blink::mojom::RecordContentToVisibleTimeRequestPtr& input) {
    return input->show_reason_unfolding;
  }

  static bool Read(::blink::mojom::RecordContentToVisibleTimeRequest::DataView input, ::blink::mojom::RecordContentToVisibleTimeRequestPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_RECORD_CONTENT_TO_VISIBLE_TIME_REQUEST_MOJOM_H_