// third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace blink::mojom::blink {


class PLATFORM_EXPORT FederatedAuthRequestInterceptorForTesting : public FederatedAuthRequest {
  virtual FederatedAuthRequest* GetForwardingInterface() = 0;
  void RequestToken(::blink::Vector<IdentityProviderGetParametersPtr> idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement requirement, RequestTokenCallback callback) override;
  void RequestUserInfo(IdentityProviderConfigPtr provider, RequestUserInfoCallback callback) override;
  void CancelTokenRequest() override;
  void ResolveTokenRequest(const ::blink::String& account_id, ::base::Value token, ResolveTokenRequestCallback callback) override;
  void SetIdpSigninStatus(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, IdpSigninStatus status, LoginStatusOptionsPtr options, SetIdpSigninStatusCallback callback) override;
  void RegisterIdP(const ::blink::KURL& url, RegisterIdPCallback callback) override;
  void UnregisterIdP(const ::blink::KURL& url, UnregisterIdPCallback callback) override;
  void CloseModalDialogView() override;
  void PreventSilentAccess(PreventSilentAccessCallback callback) override;
  void Disconnect(IdentityCredentialDisconnectOptionsPtr options, DisconnectCallback callback) override;
};
class PLATFORM_EXPORT FederatedAuthRequestAsyncWaiter {
 public:
  explicit FederatedAuthRequestAsyncWaiter(FederatedAuthRequest* proxy);

  FederatedAuthRequestAsyncWaiter(const FederatedAuthRequestAsyncWaiter&) = delete;
  FederatedAuthRequestAsyncWaiter& operator=(const FederatedAuthRequestAsyncWaiter&) = delete;

  ~FederatedAuthRequestAsyncWaiter();
  void RequestToken(
      ::blink::Vector<IdentityProviderGetParametersPtr> idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement requirement, RequestTokenStatus* out_status, std::optional<::blink::KURL>* out_selected_identity_provider_config_url, std::optional<::base::Value>* out_token, TokenErrorPtr* out_error, bool* out_is_auto_selected);
  
  void RequestUserInfo(
      IdentityProviderConfigPtr provider, RequestUserInfoStatus* out_status, std::optional<::blink::Vector<IdentityUserInfoPtr>>* out_user_info);
  
  void ResolveTokenRequest(
      const ::blink::String& account_id, ::base::Value token, bool* out_success);
  bool ResolveTokenRequest(const ::blink::String& account_id, ::base::Value token);
  void SetIdpSigninStatus(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, IdpSigninStatus status, LoginStatusOptionsPtr options);
  
  void RegisterIdP(
      const ::blink::KURL& url, RegisterIdpStatus* out_status);
  RegisterIdpStatus RegisterIdP(const ::blink::KURL& url);
  void UnregisterIdP(
      const ::blink::KURL& url, bool* out_success);
  bool UnregisterIdP(const ::blink::KURL& url);
  void PreventSilentAccess(
      );
  
  void Disconnect(
      IdentityCredentialDisconnectOptionsPtr options, DisconnectStatus* out_status);
  DisconnectStatus Disconnect(IdentityCredentialDisconnectOptionsPtr options);

 private:
  FederatedAuthRequest* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_TEST_UTILS_H_